/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.api.tools;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;

public class ProcessForker extends Thread {

	private int threadId;
	private ProcessDefinition process;
	private AbstractProcessDefinitionRegistry<ProcessDefinition> registry;
	private List<ProcessKey> keys;


	private Logger _log = Logger.getLogger(ProcessForker.class.getName());
	
	public ProcessForker(int threadId, ProcessDefinition process, AbstractProcessDefinitionRegistry registry, List<ProcessKey> keys){
		this.threadId = threadId;
		this.process = process;
		this.registry = registry;
		this.keys = keys;
	}

	public void run(){
		try{
			
			final Process processInstance = this.registry.getModel().getCompiler().compile(this.process);

			processInstance.run();
			this._log.finest("Process"+processInstance.getName()+" n°"+this.threadId+" successfully started.");
		}catch(CoreException e){
			this._log.severe(e.getMessage());
		}
	}
	
	public int getThreadId() {
		return threadId;
	}

	public ProcessDefinition getProcess() {
		return process;
	}

	public AbstractProcessDefinitionRegistry<ProcessDefinition> getRegistry() {
		return registry;
	}

	public List<ProcessKey> getKeys() {
		return keys;
	}
	
}//
