/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.factory;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import java.util.logging.Logger;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

public abstract class AbstractFactoryImpl {
    public static final String DEFAULT_FACTORY_NAME = "core";
    private static Logger log = Logger.getLogger(AbstractFactoryImpl.class.getName());
    private static Core core = null;

    protected Core createCore(String name, ConfigurationEngine configuration, Class<? extends Core> coreClass) throws CoreException {
        Component coreComponent = this.createCoreComposite(coreClass);
        try {
            SCAHelper.getSCAHelper().startComponent(coreComponent);
            AbstractFactoryImpl.setCore(coreComponent);
            if (name != null) {
                SCAHelper.getSCAHelper().changeName(coreComponent, name);
            }
            AbstractFactoryImpl.setCore(coreComponent);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        log.finest("core created and started");
        return core;
    }

    private static void setCore(Component coreComponent) throws NoSuchInterfaceException, CoreException {
        SCAContentController scacc = (SCAContentController)coreComponent.getFcInterface("/sca-content-controller");
        try {
            core = (Core)scacc.getFcContent();
        }
        catch (ContentInstantiationException e) {
            throw new CoreException(e);
        }
    }

    private Component createCoreComposite(Class<? extends Core> coreClass) throws CoreException {
        Component coreComponent = null;
        try {
            coreComponent = SCAHelper.getSCAHelper().createNewComponent(coreClass.getName(), null);
            SCAHelper.getSCAHelper().changeName(coreComponent, DEFAULT_FACTORY_NAME);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return coreComponent;
    }

    public static Core getCore() {
        return core;
    }
}

