/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.api.marshalling.factory;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easyviper.core.api.CoreException;

/**
 * This interface describes operations needed to (u)marshal
 * EasyViper elements E.
 * 
 */
public interface Factory<E> {

		E read(Document doc) throws CoreException;
		
		Document getDocument(E e) throws CoreException;
		
		E create() throws CoreException;
}
