/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.engine.fault;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface FaultHandler {

    void setLog(Logger logger);

    void assignExceptionVariable(Execution execution, CoreException exception, 
            Variable variable) throws CoreException;
    
    boolean match(Execution execution, Fault f, CoreException e, Scope faultScope) throws CoreException;

    <Ex extends CoreException> Ex getBPELExceptionFromGenericException(Scope scope,
            CoreException e, BindingMessageAdapter.Direction direction, boolean isBindingStyleRpc)
            throws CoreException;

}
