/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.model.registry.definition;

import java.net.URI;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.Element;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 * @author Julien Lesbegueries - EBM WebSourcing
 */
//@Interface(name = "service")
public interface ProcessDefinitionRegistry<Def extends ProcessDefinition>
extends SCAComponent {
	
	void setLog(final Logger logger);

	ProcessDefinition storeProcessDefinition(URI bpeluri, ProcessContextDefinition context) throws CoreException;

	void unStoreProcessDefinition(final URI uri, boolean forceUninstall) throws CoreException;

	Def getProcessDefinition(ProcessKey name);
	
	ProcessKey findProcessKey(QName processDefinition);

	List<Def> getAllProcessDefinitions();

	Def removeProcessDefinition(ProcessKey name, boolean forceUninstall) throws CoreException;

	List<ProcessKey> createKeys(ProcessDefinition processDefinition) throws CoreException;
	
	StaticAnalysis getStaticAnalysis();

	void setStaticAnalysis(StaticAnalysis staticAnalysis);

	StaticAnalysisPrinter getStaticAnalysisPrinter();

	void setStaticAnalysisPrinter(StaticAnalysisPrinter staticAnalysisPrinter);

	<D extends ProcessDefinition > boolean isCreateInstance(D def, Message mess) throws CoreException;
	
	
	
	
	

}
