/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.engine.configuration;

import java.util.List;

import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface ConfigurationEngine {

    boolean getSingleThreadedExecution();
    void setSingleThreadedExecution(boolean singleThreadedExecution);
	Boolean getExplorer();
	void setExplorer(Boolean explorer);
	Integer getAutoFlushMessageFrequency();
	void setAutoFlushMessageFrequency(Integer frequency);
	Integer getAutoTrashProcessFrequency();
	void setAutoTrashProcessFreqeuency(Integer frequency);
	List<Class<? extends Service>> getAdditionnalServices();
	void setAdditionnalServices(List<Class<? extends Service>> services);
    boolean getSynchronousRun();
    void setSynchronousRun(boolean synchronousRun);
}
