/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.model;

import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
//@Interface(name = "service")
public interface Model extends SCAComponent {

	ProcessDefinitionRegistry<? extends ProcessDefinition> createRegistry(
			String name,
			Class<? extends AbstractProcessDefinitionRegistry> registryClass)
			throws CoreException;

	ProcessDefinitionRegistry<? extends ProcessDefinition> getRegistry()
			throws CoreException;

	Compiler createCompiler(String name,
			Class<? extends AbstractCompiler> compilerClass)
			throws CoreException;

	Compiler getCompiler() throws CoreException;

	Core getCore() throws CoreException;
	
	void setLog(Logger logger);
}
