/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.env;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
//@Interface(name = "service")
public interface ExternalEnvironment extends SCAComponent {

	void setLog(final Logger logger);
	
	Receiver addReceiver(Class<? extends Receiver> receiverClass) throws CoreException;

	Sender addSender(Class<? extends Sender> senderClass) throws CoreException;

	List<Receiver> getReceivers() throws CoreException;

	List<Sender> getSenders() throws CoreException;
	
	String getHost();
	
	void setHost(String host);
	
	String getPort();
	
	void setPort(String port);

	Engine getEngine();
}
