/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.engine;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import org.jdom.Element;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public interface Execution extends SCAComponent {

    /**
     * <ul>
     * <li>
     * ACTIVE : the execution is started.</li>
     * <li>
     * INACTIVE : the execution is alive but not started.</li>
     * <li>
     * ENDED : an execution has ended if it has no more node to execute.</li>
     * <li>
     * CANCELLED : an execution enters cancelled state if an exit node was
     * executed.</li>
     * <li>
     * SUSPENDED : an execution is suspended if it relies on an external event
     * (such as an external message waited by a receiver) to execute its
     * subsequents nodes.</li>
     * </ul>
     * 
     * @author mjambert
     * 
     */
    enum State {
        ACTIVE, INACTIVE, ENDED, CANCELLED, SUSPENDED
    };

    void setLog(Logger logger);

    Execution getParentExecution();
    
    List<Execution> getChildExecutions();

    Scope getCurrentScope(); 
    
    Map<String, Execution> getSuspendedExecutions() throws CoreException;

    void addExecution(Execution execution) throws CoreException;

    void removeChildExecutions() throws CoreException;

    void removeChildExecution(Execution execution) throws CoreException;

    void run() throws CoreException;

    void runStepByStep() throws CoreException;

    void signal() throws CoreException;

    void end() throws CoreException;

    void setState(State state);

    void setStateRecursively(State state);

    State getState();

    void step() throws CoreException;

    boolean isStepByStep();

    void setStepByStep(boolean stepByStep);

    boolean hasCurrentTarget();

    Node getCurrentTarget();

    void setInitialTarget(Node initialTarget);

    Exception getException();

    void enterScope(Scope scope);

    void leaveScope();

//    Set<String> getInScopeVariableNames();
    
    Object getVariableValue(String name);

    void putVariableValue(String name, Object value);

    void assignVariableValue(String name, Object value);
    
    Element getPartnerValue(String name);
    
    void putPartnerValue(String name, Element value);

    void assignPartnerValue(String name, Element value);
}
