/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.model.compiler.validation;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public abstract class AbstractStaticAnalysisPrinter implements StaticAnalysisPrinter{


//	private static AbstractStaticAnalysisPrinter instance = null;

	
	
//	public static AbstractStaticAnalysisPrinter getInstance() {
//		if(instance == null) {
//			instance = new AbstractStaticAnalysisPrinter();
//		}
//		return instance;
//	}
	
	protected AbstractStaticAnalysisPrinter(){
		
	}
	
	public List<String> printErrorsAsString(final List<Error> errors) {
		final List<String> res = new ArrayList<String>();
		for(final Error e: errors) {
			res.add(e.getError().getMessage());
		}
		return res;
	}
	

	public String printAllErrors(final List<Error> errors) {
		String res = "";
		for(final String s: this.printErrorsAsString(errors)) {
			res = res + s + "\n";
		}
		return res;
	}

	public String printAllWarnings(final List<Warning> warnings) {
		String res = "";
		for(final Warning w: warnings) {
			res = res + w.getWarning() + "\n";
		}
		return res;
	}
	
	public String printAllInfos(final List<Info> infos) {
		String res = "";
		for(final Info i: infos) {
			res = res + i.getInfo() + "\n";
		}
		return res;
	}
	
	public String printAll(final List<Error> errors, final List<Warning> warnings, final List<Info> infos) {
		String res = "";
		if((infos != null) && (infos.size() > 0)) {
			res = res + infos.size() + " Infos:\n" + this.printAllInfos(infos);
		}
		if(res.length() > 0) {
			res = res + "\n";
		}
		if((warnings != null) && (warnings.size() > 0)) {
			res = res + warnings.size() + " Warnings:\n" + this.printAllWarnings(warnings);
		}
		if(res.length() > 0) {
			res = res + "\n";
		}
		if((errors != null) && (errors.size() > 0)) {
			res = res + errors.size() + " Errors:\n" + this.printAllErrors(errors);
		}
		return res;
	}

}
