/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api;

import java.nio.channels.UnsupportedAddressTypeException;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class CoreException extends RuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String name = this.getClass().getName();
	
	private Message fault = null;
	
	/**
	 * 
	 */
	public CoreException() {
		super();
	}

	/**
	 * @param message
	 */
	public CoreException(final String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public CoreException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 */
	public CoreException(final Throwable cause) {
		this(null, cause);
		if (cause instanceof CoreException) {
			setFault(((CoreException) cause).getFault());
		}
	}

	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}
	
	
	public String getFaultVariableName() {
	    return null;
	}
	
	
    public void setFaultVariableName(String faultVariableName) {
        throw new UnsupportedOperationException();
    }
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof CoreException)) {
			return false;
		}
		CoreException other = (CoreException) obj;
		if (name == null) {
			if (other.name != null) {
				return false;
			}
		} else if (!name.equals(other.name)) {
			return false;
		}
		return true;
	}
	
	public Message getFault() {
		return fault;
	}

	public void setFault(Message fault) {
		this.fault = fault;
	}
	
	public void resolveFaultMessage(Execution execution) throws CoreException {
		// default is doing nothing. overriden in UserDefinedException.
	}
	
}
