/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.api.model.registry.definition;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysis;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.StaticAnalysisPrinter;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.api.tools.ProcessForker;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

@Scope(value="COMPOSITE")
@Service(value={ProcessDefinitionRegistry.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public abstract class AbstractProcessDefinitionRegistry<Def extends ProcessDefinition>
extends SCAComponentImpl
implements ProcessDefinitionRegistry<Def> {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(AbstractProcessDefinitionRegistry.class.getName());
    protected Map<ProcessKey, Def> registry = new HashMap<ProcessKey, Def>();
    private StaticAnalysis staticAnalysis;
    private StaticAnalysisPrinter staticAnalysisPrinter;

    @Override
    public ProcessKey findProcessKey(QName processDefinitionName) {
        ProcessKey pk = null;
        for (Map.Entry<ProcessKey, Def> entry : this.registry.entrySet()) {
            if (!((ProcessDefinition)entry.getValue()).getQName().equals(processDefinitionName)) continue;
            pk = entry.getKey();
            break;
        }
        return pk;
    }

    public Model getModel() throws CoreException {
        Model res = null;
        try {
            Component modelComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Model)modelComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        catch (SCAException e) {
            throw new CoreException(e);
        }
        return res;
    }

    @Override
    public StaticAnalysis getStaticAnalysis() {
        return this.staticAnalysis;
    }

    @Override
    public void setStaticAnalysis(StaticAnalysis staticAnalysis) {
        this.staticAnalysis = staticAnalysis;
    }

    @Override
    public StaticAnalysisPrinter getStaticAnalysisPrinter() {
        return this.staticAnalysisPrinter;
    }

    @Override
    public void setStaticAnalysisPrinter(StaticAnalysisPrinter staticAnalysisPrinter) {
        this.staticAnalysisPrinter = staticAnalysisPrinter;
    }

    @Override
    public synchronized ProcessDefinition storeProcessDefinition(URI uri, ProcessContextDefinition context) throws CoreException {
        ProcessDefinition processDefinition = null;
        processDefinition = (ProcessDefinition)this.getModel().getCompiler().validate(uri);
        log.finest("Number of process instances : " + this.getModel().getCore().getEngine().getProcessInstanceRegistry().getProcessInstances().size());
        if (this.getStaticAnalysis() != null && this.getStaticAnalysisPrinter() != null) {
            if (this.getStaticAnalysis().getErrors().size() > 0) {
                String msg = this.getStaticAnalysisPrinter().printAll(this.getStaticAnalysis().getErrors(), this.getStaticAnalysis().getWarnings(), this.getStaticAnalysis().getInfos());
                throw new CoreException("Compilation Error: " + msg, (Throwable)this.getStaticAnalysis().getErrors().get(0).getError());
            }
            if (this.getStaticAnalysis().getWarnings().size() > 0) {
                String msg = this.getStaticAnalysisPrinter().printAll(this.getStaticAnalysis().getErrors(), this.getStaticAnalysis().getWarnings(), this.getStaticAnalysis().getInfos());
                log.finest("Compilation warning: " + msg);
            }
            List<ProcessKey> keys = null;
            keys = this.createKeys(processDefinition);
            if (keys == null || keys.size() == 0) {
                throw new CoreException("The keys cannot be null");
            }
            String logMsg = "\nList of key :\n";
            for (ProcessKey key : keys) {
                logMsg = logMsg + key;
                this.registry.put(key, processDefinition);
            }
            log.finest(logMsg);
            if (context.getPoolSize() > 0) {
                Process processInstance = this.getModel().getCompiler().compile(processDefinition);
                this.getModel().getCore().getEngine().run(processInstance);
                log.info("First process started");
                while (!processInstance.hasExecution() && processInstance.getExecution().getState() != Execution.State.SUSPENDED) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {}
                }
                for (int cpt = 1; cpt < context.getPoolSize(); ++cpt) {
                    ProcessForker forker = new ProcessForker(cpt, processDefinition, this, keys);
                    this.getModel().getCore().getEngine().getPoolOfProcessForkers().addProcessForkers(forker);
                    forker.start();
                    log.finest("process number" + cpt + " is going to be stored ...");
                }
            }
        } else {
            log.severe("StaticAnalysis and StaticAnalysisPrinter MUST be set for this definition model.");
        }
        return processDefinition;
    }

    @Override
    public void unStoreProcessDefinition(URI uri, boolean forceUninstall) throws CoreException {
        ProcessDefinition processDefinition = null;
        processDefinition = (ProcessDefinition)this.getModel().getCompiler().validate(uri);
        List<ProcessKey> keys = null;
        keys = this.createKeys(processDefinition);
        if (keys != null) {
            for (ProcessKey key : keys) {
                this.removeProcessDefinition(key, forceUninstall);
            }
        }
    }

    @Override
    public void setLog(Logger logger) {
        log = logger;
    }

    @Override
    public abstract List<ProcessKey> createKeys(ProcessDefinition var1) throws CoreException;

    @Override
    public abstract <D extends ProcessDefinition> boolean isCreateInstance(D var1, Message var2) throws CoreException;
}

