/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.api.tools;

import java.util.List;
import java.util.logging.Logger;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;

public class ProcessForker extends Thread {

    private int threadId;

    private ProcessDefinition process;

    private AbstractProcessDefinitionRegistry<ProcessDefinition> registry;

    private List<ProcessKey> keys;

    private Logger _log = Logger.getLogger(ProcessForker.class.getName());

    public ProcessForker(int threadId, ProcessDefinition process,
            AbstractProcessDefinitionRegistry registry, List<ProcessKey> keys) {
        this.threadId = threadId;
        this.process = process;
        this.registry = registry;
        this.keys = keys;
    }

    
    public void run() {
        try {

            final Process processInstance = this.registry.getModel().getCompiler()
                    .compile(this.process);
            this.registry.getModel().getCore().getEngine().run(processInstance);
            this._log.finest("Process" + processInstance.getName() + " no" + this.threadId
                    + " successfully started.");
        } catch (CoreException e) {
            this._log.severe(e.getMessage());
        }
    }
    
    public List<ProcessKey> getKeys() {
        return keys;
    }

}//
