/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easyviper.core.api.soa.message.Header;

public class HeaderImpl implements Header {

	private Map<QName, Document> properties;
	
	
	public HeaderImpl() {
		properties = new HashMap<QName, Document>();
	}
	
	public void addProperty(QName id, Document prop) {
		this.properties.put(id, prop);
	}

	public void clearProperties() {
		this.properties.clear();

	}

	public Document[] getProperties() {
		return (Document[]) this.properties.values().toArray();
	}
	
	public Map<QName, Document> getPropertiesMap(){
		return this.properties;
	}

	public Document getProperty(QName qname) {
		return this.properties.get(qname);
	}

	public Document removeProperty(QName qname) {
		return this.properties.remove(qname);
	}

}
