/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractReceiverImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Service(value=MemoryReceiver.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class MemoryReceiverImpl extends AbstractReceiverImpl implements
		MemoryReceiver {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(MemoryReceiverImpl.class.getName());

	private final List<DatedExternalMessage> messages = new ArrayList<DatedExternalMessage>();

	@SuppressWarnings("unchecked")
	public void accept(final ExternalMessage externalMessage, final ExternalContext context)
			throws CoreException {
		this.messages.add(new DatedExternalMessage(externalMessage));

		if (this.messageConverter == null) {
			throw new CoreException(
					"Configuration error: The message converter and the type of internal message must be setted");
		}

		// convert message
		final InternalMessage<?> internalMessage = this.messageConverter
				.createInternalMessageFromExternalMessage(externalMessage);

		// give the message to core
		this.log.finest("the receiver gives the message to workflow engine");
		this.getExternalEnvironment().getEngine().accept(internalMessage,
				context);
	}

	public List<DatedExternalMessage> getMessages() {
		return this.messages;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

}
