/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class DefaultBehaviour {

	static final public Behaviour EMPTY_BEHAVIOUR = new EmptyBehaviourImpl();
	static final public Behaviour WAIT_BEHAVIOUR = new WaitBehaviourImpl();
	static final public Behaviour BREAKPOINT_BEHAVIOUR = new ForkBehaviourImpl();

	static public List<Behaviour> getDefaultBehaviour() {
		final List<Behaviour> res = new ArrayList<Behaviour>();
		res.add(DefaultBehaviour.EMPTY_BEHAVIOUR);
		res.add(DefaultBehaviour.WAIT_BEHAVIOUR);
		res.add(DefaultBehaviour.BREAKPOINT_BEHAVIOUR);
		return res;
	}
}
