/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ExclusiveBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExclusiveBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ForkBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.IfBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.LoopBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ScopeBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SequenceBehaviourImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class CreationPatternFactory {

	private static CreationPatternFactory instance;

	private CreationPatternFactory() {

	}

	public static CreationPatternFactory getInstance() {
		if (CreationPatternFactory.instance == null) {
			CreationPatternFactory.instance = new CreationPatternFactory();
		}
		return CreationPatternFactory.instance;
	}

	public Node createSequencePattern(final String name, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}


			parentNode = scope.createNode(name, SequenceBehaviourImpl.class, null);


			if (childNodes != null) {
				// link nodes between them
				final Iterator<Node> it = childNodes.iterator();
				Node source = null;
				Node target = null;
				Node lastNode = null;
				Component sourceComp = null;
				Component targetComp = null;
				Component lastComp = null;

				while (it.hasNext()) {
					source = it.next();
					sourceComp = SCAHelper.getSCAHelper()
							.getComponentByInterface(scope.getComponent(),
									(org.objectweb.fractal.api.Interface) source,
									"service");

					String sourceName = SCAHelper.getSCAHelper().getName(
							sourceComp);

					if (lastNode != null) {
						scope.linkedBrotherNodes(lastNode, source);
					}

					if (it.hasNext()) {

						target = it.next();
						targetComp = SCAHelper
								.getSCAHelper()
								.getComponentByInterface(
										scope.getComponent(),
										(org.objectweb.fractal.api.Interface) target,
										"service");

						scope.linkedBrotherNodes(source, target);


						lastNode = target;
						lastComp = targetComp;
					} else {
						lastNode = null;
						lastComp = null;
					}
				}

				// link all children to parent
				if (childNodes != null) {
					for (final Node children : childNodes) {
						scope.linkedChildNodeToParent(parentNode, children);
					}
				}

			}
		} catch(SCAException e) {
			throw new CoreException(e);
		}
		return parentNode;
	}


	public Node createScopePattern(final String name,
			final Scope scope) throws CoreException {
		Node underscope = null; 
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}

			final Component underscopeComp = SCAHelper.getSCAHelper()
					.createNewComponent(ScopeImpl.class.getName(), null);

			// add scope in process
			SCAHelper.getSCAHelper().addComponent(underscopeComp,
					scope.getComponent(), null);

			//			underscope = (Scope) underscopeComp.getFcInterface("/content");
			SCAContentController scacc = (SCAContentController)
					underscopeComp.getFcInterface(SCAContentController.NAME);
			try {
				underscope = (Scope) scacc.getFcContent();
			}
			catch (ContentInstantiationException e) {
				throw new CoreException(e);
			}
			//			(underscope).init(underscopeComp);
			underscope.setName(name);
			if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
				underscope.setLog(scope.getLogger());
			}

			// Start the scope
			SCAHelper.getSCAHelper().startComponent(underscopeComp);
			underscope = (Node) underscopeComp.getFcInterface("service");

			// create behaviour
			final Component fractalActivity = SCAHelper.getSCAHelper()
					.createNewComponent(ScopeBehaviourImpl.class.getName(),
							null);
			SCAHelper.getSCAHelper().changeName(
					fractalActivity,
					ScopeBehaviourImpl.class.getSimpleName()
					+ "4"
					+ SCAHelper.getSCAHelper().getName(
							underscopeComp));
			SCAHelper.getSCAHelper().addComponent(fractalActivity,
					scope.getComponent(), null);
			//			FunctionnalBehaviour behaviour = (FunctionnalBehaviour) fractalActivity
			//			.getFcInterface("/content");
			scacc = (SCAContentController)
					fractalActivity.getFcInterface(SCAContentController.NAME);
			Behaviour behaviour;
			try {
				behaviour = (Behaviour) scacc.getFcContent();
			}
			catch (ContentInstantiationException e) {
				throw new CoreException(e);
			}
			//			((Behaviour) behaviour).init(fractalActivity);
			if (!scope.getLogger().getName().equals(ScopeImpl.class.getName())) {
				behaviour.setLog(scope.getLogger());
			}
			behaviour = (Behaviour) fractalActivity.getFcInterface("service");

			scope.linkedNodeAndFunctionnalBehaviour(underscope, behaviour);
			underscope.setActivity(behaviour);

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		return underscope;
	}

	public Node createIfPattern(final String name,
			final List<ConditionalExpression> expressions, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}
		if ((expressions == null)
				|| (expressions.size() == 0)
				|| ((childNodes.size() == expressions.size()) && (childNodes
						.size() == expressions.size() + 1))) {
			throw new CoreException("Invalid if pattern");
		}

		//		final IfBehaviour ifBehaviour = new IfBehaviourImpl();
		//		ifBehaviour.setConditions(expressions);
		//		
		Map<String, Object> context = new HashMap<String, Object>();
		context.put("conditions", expressions);
		parentNode = scope.createNode(name, IfBehaviourImpl.class, context);

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linkedChildNodeToParent(parentNode, children);
			}
		}

		return parentNode;
	}

	public Node createSeveralReceiversPattern(final String name,
			final List<ReceiverBehaviour> receivers, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}
			if ((receivers == null) || (receivers.size() == 0)
					|| ((childNodes.size() != receivers.size()))) {
				throw new CoreException("Invalid several receivers pattern");
			}

			// create the list of variable
			final List<QName> variableNames = new ArrayList<QName>();
			for (final ReceiverBehaviour receiver : receivers) {
				variableNames.addAll(SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "variableNames", List.class));
			}

			Map<String, Object> context = new HashMap<String, Object>();
			//final ReceiverBehaviour severalReceiversBehaviour = new ReceiverBehaviourImpl();
			//severalReceiversBehaviour.getVariableNames().addAll(variableNames);
			context.put("variableNames", variableNames);

			// set message matcher
			MessageMatcher matcher = SCAHelper.getSCAHelper().getPropertyValue(receivers.get(0).getComponent(), "messageMatcher", MessageMatcher.class);
			for(final ReceiverBehaviour receiver : receivers) {
				if(matcher != SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "messageMatcher", MessageMatcher.class)) {
					throw new CoreException("Sorry but all receivers must have the same message matcher");
				}
			}
			//severalReceiversBehaviour.setMessageMatcher(matcher);
			context.put("messageMatcher", matcher);


			// set correlation matcher
			List<CorrelationMatcher> correlationsMatcher = null;
			for(final ReceiverBehaviour receiver : receivers) {
				if(SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "correlationsMatcher", List.class) != null) {
					if(correlationsMatcher == null) {
						correlationsMatcher = new ArrayList<CorrelationMatcher>();
					}
					correlationsMatcher.addAll(SCAHelper.getSCAHelper().getPropertyValue(receiver.getComponent(), "correlationsMatcher", List.class));

				}
			}
			//severalReceiversBehaviour.setCorrelationsMatchers(correlationsMatcher);
			context.put("correlationsMatcher", correlationsMatcher);

			parentNode = scope.createNode(name, ReceiverBehaviourImpl.class, context);

			// link all children to parent
			if (childNodes != null) {
				for (final Node children : childNodes) {
					scope.linkedChildNodeToParent(parentNode, children);
				}
			}
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		return parentNode;
	}

	public Node createLoopPattern(final String name, final ConditionalExpression condition, final boolean applyConditionAtBegin,
			final List<Node> childNodes, final Scope scope) throws CoreException {
		Node parentNode = null;
		try {
			if (scope == null) {
				throw new CoreException("scope cannot be null");
			}

			if (condition == null) {
				throw new CoreException("condition cannot be null");
			}

			//	final LoopBehaviour loopBehaviour = new LoopBehaviourImpl();
			//	loopBehaviour.setCondition(condition);
			//	loopBehaviour.setApplyConditionAtBegin(applyConditionAtBegin);
			Map<String, Object> context = new HashMap<String, Object>();
			context.put("condition", condition);
			context.put("applyConditionAtBegin", applyConditionAtBegin);
			parentNode = scope.createNode(name, LoopBehaviourImpl.class, context);

			if (childNodes != null) {
				// link nodes between them
				final Iterator<Node> it = childNodes.iterator();
				Node source = null;
				Node target = null;
				Node lastNode = null;
				Component sourceComp = null;
				Component targetComp = null;
				Component lastComp = null;
				String transitionName = "t";
				while (it.hasNext()) {
					source = it.next();
					sourceComp = SCAHelper.getSCAHelper()
							.getComponentByInterface(scope.getComponent(),
									(org.objectweb.fractal.api.Interface) source,
									"service");

					if (lastNode != null) {
						scope.linkedBrotherNodes(lastNode, source);

					}

					if (it.hasNext()) {
						target = it.next();
						targetComp = SCAHelper
								.getSCAHelper()
								.getComponentByInterface(
										scope.getComponent(),
										(org.objectweb.fractal.api.Interface) target,
										"service");

						scope.linkedBrotherNodes(source, target);


						lastNode = target;
						lastComp = targetComp;
					} else {
						lastNode = null;
						lastComp = null;
					}
				}

				// link all children to parent
				if (childNodes != null) {
					for (final Node children : childNodes) {
						scope.linkedChildNodeToParent(parentNode, children);
					}
				}
			}
		} catch(SCAException e) {
			throw new CoreException(e);
		}
		return parentNode;
	}

	public Node createForkPattern(final String name, final List<Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}

		parentNode = scope.createNode(name, ForkBehaviourImpl.class, null);

		// link all children to parent
		if (childNodes != null) {
			for (final Node children : childNodes) {
				scope.linkedChildNodeToParent(parentNode, children);
			}
		}
		return parentNode;
	}

	public Node createExclusivePattern(final String name, final Map<Node,Node> childNodes,
			final Scope scope) throws CoreException {
		Node parentNode = null;

		if (scope == null) {
			throw new CoreException("scope cannot be null");
		}

		//		ExclusiveBehaviour excl = new ExclusiveBehaviourImpl();
		//		if(childNodes != null) {
		//			excl.setTriggeringNodes(childNodes.keySet());
		//		}
		Map<String, Object> context = new HashMap<String, Object>();
		if(childNodes != null) {
			context.put("triggeringNodes", childNodes.keySet());
		}
		parentNode = scope.createNode(name, ExclusiveBehaviourImpl.class, context);


		// link children to parent
		if (childNodes != null) {
			//find  waiting child nodes
			Map<WaitBehaviour, Node> waitingNodes = new HashMap<WaitBehaviour, Node>();
			for (Node child : childNodes.keySet()) {

				try {
					final Component comp = SCAHelper.getSCAHelper()
							.getComponentByInterface(scope.getComponent(),
									(org.objectweb.fractal.api.Interface) child,
									"service");
					SCAHelper.getSCAHelper().startComponent(comp);
				} catch (SCAException e) {
					throw new CoreException(e);
				}

				if(child.getBehaviour() instanceof WaitBehaviour) {
					waitingNodes.put((WaitBehaviour) child.getBehaviour(),child);
				}
			}
			//if there are waiting child nodes : we only keep the one that will finish first
			if(!waitingNodes.isEmpty()) {
				Node fastest = findFastestWaitingNode(waitingNodes,scope);

				for (Node waitingNode : waitingNodes.values()) {
					if(!waitingNode.equals(fastest)) {
						childNodes.remove(waitingNode);
					}
				}
			}

			for (Node child : childNodes.keySet()) {
				scope.linkedChildNodeToParent(parentNode, child);

				Node follower = childNodes.get(child); 
				if(follower!=null) {
					//TODO
					//					if(!follower.getOutgoingNodes().isEmpty()) {
					//						throw new CoreException("The exclusive pattern only admits a single node or a sequence pattern after its triggering behaviours.");
					//					}

					scope.linkedChildNodeToParent(parentNode, follower);
				}
			}
		}
		return parentNode;
	}


	private Node findFastestWaitingNode(Map<WaitBehaviour, Node> waitingNodes, Scope scope) throws CoreException {
		Map<Long,Node> times = new HashMap<Long,Node>();
		for(WaitBehaviour alarm : waitingNodes.keySet()) {

			try {
				final Component comp = SCAHelper.getSCAHelper()
						.getComponentByInterface(scope.getComponent(),
								(org.objectweb.fractal.api.Interface) alarm,
								"service");
				SCAHelper.getSCAHelper().startComponent(comp);
			} catch (SCAException e) {
				throw new CoreException(e);
			}

			if(alarm.getDuration()!=null) {
				Long time = alarm.getDuration().evaluate(null);
				if(time>0) {
					times.put(time,waitingNodes.get(alarm));
				}
			}
			else if(alarm.getDate()!=null) {
				Long time = alarm.getDate().evaluate(null).getTime();
				if(time>0) {
					times.put(time,waitingNodes.get(alarm));
				}
			}
		}

		if(times.isEmpty()) {
			throw new CoreException("There is no valid waiting expression for this exclusive pattern.");
		}

		return times.get(Collections.min(times.keySet()));
	}
}
