/**
* easy VIPER software - Copyright (c) 2009 PetalsLink, 
* http://www.petalslink.com/ 
*  
* This library is free software; you can redistribute it and/or modify it under 
* the terms of the GNU Lesser General Public License as published by the Free 
* Software Foundation; either version 2.1 of the License, or (at your option) 
* any later version. This library is distributed in the hope that it will be 
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
* General Public License for more details. 
*  
* You should have received a copy of the GNU Lesser General Public License 
* along with this library; if not, write to the Free Software Foundation, Inc., 
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.Reference;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ReceiverBehaviour.class,names="service")
public class ReceiverBehaviourImpl extends AbstractBehaviourImpl implements
ReceiverBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger
	.getLogger(ReceiverBehaviourImpl.class.getName());

	private InternalMessage<?> message;

	@Property(name="variableNames", required=true)
	private List<QName> variableNames = new ArrayList<QName>();

	@Property(name="messageMatcher", required=true)
	private MessageMatcher messageMatcher = null;

	@Property(name="correlationsMatcher", required=true)
	private List<CorrelationMatcher> correlationsMatcher = new ArrayList<CorrelationMatcher>();
	
	@Property(name="providerEndpointKey", required=false)
	private Object providerEndpointKey;

	private Node childNodeSelected = null;

	private boolean isSuspended = false;


	@Override
	public String toString() {
		return "Receive Behaviour";
	}

	public boolean accept(final InternalMessage<?> message, final ExternalContext context)
	throws CoreException {
		boolean accept = false;
		this.log.finest("Message received on node: " + this.node.getName());

		// get the variable in process
		final Scope scope = this.node.getExecution().getParentScope();

		int cptChild = 0;
		for (final QName variableName : this.variableNames) {
			final Variable<?> v = scope.findVariable(variableName);
			if (v == null) {
				throw new CoreException(
						"Impossible to find in process, the variable used in the received : "
						+ this.getName());
			}

			// check the message
			boolean check = false;
			if (this.messageMatcher != null) {
				check = this.messageMatcher.match(v, message);
			} else {
				this.log.warning("no matcher found");
				check = true;
			}

			if(!check) {
				log.finest("message not valid for variable: " + variableName);
			} else {

				boolean correlationOK = false;
				if(this.correlationsMatcher != null && this.correlationsMatcher.size() > 0) {
					log.finest("Correlation found: execute correlation for receiver: " + this.getName());
					for(CorrelationMatcher corr: this.correlationsMatcher) {
						correlationOK = corr.match(scope, variableName, message);
						if(correlationOK) {
							break;
						}
					}
				} else {
					log.finest("No correlation ");
					correlationOK = true;
				}

				if ((check)&&(correlationOK)) {
					// set the message
					v.setValue(message);

					// valid the accept
					accept = true;
					this.log.finest("Message accepted on receive by variable: "
							+ variableName);
					if (this.node.getChildNodes().size() > 0) {
						this.childNodeSelected = this.node.getChildNodes().get(
								cptChild);
					}
					break;
				}
			}
			cptChild++;
		}

		return accept;
	}


	public void setMessage(final InternalMessage<?> message) {
		this.message = message;
	}

	public InternalMessage<?> getMessage() {
		return this.message;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	public Node getChildNodeSelected() {
		return this.childNodeSelected;
	}
	
	private final void executeOnSuspended() throws CoreException {
		isSuspended = false;
		this.log.finest("execute receive behaviour on node: " + this.node.getName());
		this.state = State.ACTIVITY_STARTED;

		if (this.message != null) {
			
			//TODO LESBEGU
			//retrieve endpoint from partner
			Endpoint endpoint = this.getNode().getExecution().getParentScope().findEndpoint(this.providerEndpointKey);
			//retrieve context from endpoint
			ExternalContext context = this.getNode().getExecution().getParentScope().getProcess().getExternalContext(endpoint, this.message.getOperationName());
			
			final boolean accept = this.accept(this.message, context);
			if (accept) {
				this.log.finest("Message accepted by the receive activity: "
						+ this.getName());

				if (this.getChildNodeSelected() != null) {
					getNode().getExecution().setNextExecutableElements(this, getChildNodeSelected());
				}
				this.state = State.ACTIVITY_ENDED;
				
				notifyParentBehaviour();
			} else {
				this.getNode().getExecution().setStateRecursively(
						Execution.State.SUSPENDED);
				isSuspended = true;
				this.log
				.finest("Message does not correspond - execution suspended: "
						+ this.getNode().getExecution().getState());
			}
			this.message = null;
		} else {
			this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
			isSuspended = true;
			this.log.finest("No Message - execution suspended: "
					+ this.getNode().getExecution().getState());
		}
	}
	
	
	
	@Override
	protected void executeOnEnded() throws CoreException {
	}

	@Override
	protected void executeOnInactive() throws CoreException {
		executeOnSuspended();
	}

	@Override
	protected void executeOnStarted() throws CoreException {
		if (isSuspended) {
			executeOnSuspended();
		} else {
			// TODO : check we should never enter here... probably dead code.
			this.log
			.finest("end receive behaviour on node: "
					+ this.node.getName());
			this.state = State.ACTIVITY_ENDED;
			this.log.finest("received activity ended");
			this.setMessage(null);
			this.childNodeSelected = null;
		}
	}

	
	@Override
	public void clean() {
	    super.clean();
	    
	    this.message = null;
	}

}
