/**
 * easy VIPER software - Copyright (c) 2009 PetalsLink, 
 * http://www.petalslink.com/ 
 *  
 * This library is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2.1 of the License, or (at your option) 
 * any later version. This library is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
 * General Public License for more details. 
 *  
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 *  
 * ------------------------------------------------------------------------- 
 * $Id$ 
 * ------------------------------------------------------------------------- 
 */ 
package com.ebmwebsourcing.easyviper.core.impl.engine.variable;

import javax.xml.namespace.QName;

import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;

import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.InternalMessageImpl;
import com.ebmwebsourcing.easyviper.model.Tinternalmessage;
import com.ebmwebsourcing.easyviper.model.Tvariable;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
//TODO uncomment this line when viper annotations are ready
//@ChangedFields
public abstract  class VariableImpl<T> extends AbstractSchemaElementImpl<Tvariable> implements Variable<T> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	//private static Logger log = Logger.getLogger(VariableImpl.class.getName());

	//private QName name;

	private InternalMessage<?> value;

	private MessageMatcher messageMatcher;
	
	


	public VariableImpl(Tvariable model, AbstractSchemaElementImpl<?> parent) {
		super(model, parent);
		value = new InternalMessageImpl(model.getValue(), this);
	}

	public VariableImpl() {
		super();
		this.model = new Tvariable();
		if(model.getValue() != null){
			value = new InternalMessageImpl(model.getValue(), this);
		}
	}



	public InternalMessage<?> getValue() {
		return this.value;
	}


	public void setValue(final InternalMessage value) {
		this.value = value;
		if (this.value == null) {
			this.model.setValue(null);
		} else {
			this.model.setValue((Tinternalmessage)((AbstractSchemaElementImpl)this.value).getModel());
			((AbstractSchemaElementImpl)this.value).setParent(this);
		}
	}



	public MessageMatcher getMatcher() {
		return this.messageMatcher;
	}



	public void setMatcher(final MessageMatcher messageMatcher) {
		this.messageMatcher = messageMatcher;
		
		
	}

	public String toString() {

		String res = this.getContent().toString();

		return res;
	}

	public QName getQName() {
		return this.model.getName();
	}

	public void setQName(QName name) {
		this.model.setName(name);


	}

	public QName getContent() {
		return this.getQName();
	}

	public void setContent(QName content) {
		this.setQName(content);
		
		

	}

	
	
	



}
