/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractSimpleBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ThrowBehaviour;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = ThrowBehaviour.class, names = "service")
public class ThrowBehaviourImpl extends AbstractSimpleBehaviourImpl implements ThrowBehaviour {

    @Property(name = "exception", required = true)
    private Exception exception;

    public ThrowBehaviourImpl() {
    }


    @Override
    protected void doExecute(Execution execution) {
        assert exception != null;
        if (!(this.exception instanceof CoreException)) {
            // TODO : if the fault message is null here on rethrown core
            // exception, we must regenerate a new
            // empty message with xsd2xml.
            throw new CoreException(this.exception);
        } else {
            CoreException coreException = (CoreException) this.exception;
            coreException.resolveFaultMessage(execution);
            // TODO : if the fault message is null here on rethrown core
            // exception, we must regenerate a new
            // empty message with xsd2xml.
            throw coreException;
        }

    }

}
