/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionThread
extends Thread {
    Logger log = Logger.getLogger(ExecutionThread.class.getSimpleName());
    private final Execution execution;
    private final ExternalEnvironment externalEnvironment;

    public ExecutionThread(Execution execution, ExternalEnvironment externalEnvironment, Logger logger) {
        super(execution.getName());
        this.execution = execution;
        this.externalEnvironment = externalEnvironment;
    }

    public Execution getExecution() {
        return this.execution;
    }

    @Override
    public void run() {
        try {
            if (this.execution.isStepByStep()) {
                this.execution.runStepByStep();
            } else {
                this.execution.run();
            }
        }
        catch (Exception e) {
            if (!(e instanceof CoreException)) {
                throw new UncheckedException((Throwable)e);
            }
            if (this.execution.getParentExecution() == null) {
                this.log.log(Level.INFO, String.format("Fault occured during main '%s' (propagated upward, client notified!).", this.execution.getName()), e);
                CoreException ce = (CoreException)((Object)e);
                if (!this.externalEnvironment.getSenders().isEmpty()) {
                    ((Sender)this.externalEnvironment.getSenders().get(0)).sendTo((CoreException)((Object)e), this.execution.getCurrentScope().getProcess().getExternalContexts());
                }
                throw ce;
            }
            this.log.log(Level.INFO, String.format("Fault occured during execution of child execution '%s' (not propagated upward!).", this.execution.getName()), e);
        }
    }
}

