/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.ExpressionEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.PartnerEvaluator;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.handler.TerminationHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationGroup;
import com.ebmwebsourcing.easyviper.core.impl.engine.NodeImpl;
import com.ebmwebsourcing.easyviper.tools.InstanceOfUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Property;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Scope.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ScopeImpl
extends NodeImpl
implements Scope {
    private static int cpt_childsNode = 0;
    private static int cpt_incomingNode = 0;
    private static int cpt_outgoingNode = 0;
    private static Logger log = Logger.getLogger(ScopeImpl.class.getSimpleName());
    protected Component initialNode;
    @Property(name="exceptions", required=false)
    private Map<Fault, Scope> exceptions = new HashMap<Fault, Scope>();
    @Property(name="partners", required=false)
    protected Map<String, Partner> partners = new HashMap<String, Partner>();
    @Property(name="correlationGroups", required=false)
    protected List<CorrelationGroup> correlationGroups = new ArrayList<CorrelationGroup>();
    @Property(name="faultScope", required=false)
    protected Exception faultScope = null;
    @Property(name="terminationHandler", required=false)
    protected TerminationHandler terminationHandler = null;
    @Property(name="variables", required=true)
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    @Property(name="expressionEvaluator", required=true)
    protected ExpressionEvaluator expressionEvaluator = null;
    @Property(name="partnerEvaluator", required=true)
    protected PartnerEvaluator partnerEvaluator = null;

    public Node createNode(String behaviourName, Class<? extends Behaviour> behaviourContextClass, Map<String, Object> context) throws CoreException {
        log.fine("start create node");
        Node node = null;
        String nodeName = null;
        try {
            if (behaviourName == null) {
                behaviourName = behaviourContextClass.getSimpleName();
                nodeName = "node_supporting_" + behaviourName + "_" + this.getAllNodes().size();
            } else {
                nodeName = "node_supporting_" + behaviourName;
            }
            Component fractalNode = SCAHelper.getSCAHelper().createNewComponent(NodeImpl.class.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalNode, this.getComponent(), null);
            SCAContentController scacc = (SCAContentController)fractalNode.getFcInterface("/sca-content-controller");
            try {
                node = (Node)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            node.setName(nodeName);
            if (!log.getName().equals(ScopeImpl.class.getName())) {
                node.setLog(log);
            }
            node = (Node)fractalNode.getFcInterface("service");
            Component fractalBehaviour = SCAHelper.getSCAHelper().createNewComponent(behaviourContextClass.getName(), context);
            SCAHelper.getSCAHelper().changeName(fractalBehaviour, behaviourName);
            SCAHelper.getSCAHelper().addComponent(fractalBehaviour, this.getComponent(), null);
            Behaviour behaviour = null;
            scacc = (SCAContentController)fractalBehaviour.getFcInterface("/sca-content-controller");
            try {
                behaviour = (Behaviour)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            behaviour = (Behaviour)fractalBehaviour.getFcInterface("service");
            this.linkedNodeAndFunctionnalBehaviour(node, behaviour);
            log.fine("Creation of the fractal node: " + behaviourName);
        }
        catch (NoSuchInterfaceException e) {
            log.severe(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            log.severe(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        log.fine("end of create node");
        return node;
    }

    public Node getInitialNode() throws CoreException {
        Node res = null;
        try {
            if (this.initialNode != null) {
                res = (Node)this.initialNode.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public Node getNode(String name) throws CoreException {
        Node res = null;
        try {
            List comps = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), name);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (comps != null) {
                for (Component comp : comps) {
                    if (!(comp.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)comp.getFcInterface("service"));
                }
            }
            if (nodes.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (nodes.size() > 0) {
                res = (Node)nodes.get(0);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void end(boolean clean) throws CoreException {
        try {
            if (this.terminationHandler != null) {
                this.terminationHandler.end((Scope)this);
            }
            if (clean) {
                log.fine("clean all scopes");
                this.cleanScopes(this);
                log.fine("stop all sub components");
                SCAHelper.getSCAHelper().stopAllSubComponents(this.getComponent());
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    protected void cleanScopes(Scope scope) throws CoreException {
        for (Scope faultScope : scope.getExceptions().values()) {
            this.cleanScopes(faultScope);
        }
        scope.setException(null);
    }

    public boolean removeNode(Node node) throws CoreException {
        boolean res = true;
        try {
            Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)node, "service");
            Node child = null;
            String clientItfName = "childNodes_";
            Map map = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(nodeComp);
            Iterator entries = map.entrySet().iterator();
            Map.Entry entry = null;
            while (entries != null && entries.hasNext()) {
                entry = entries.next();
                if (!((String)entry.getKey()).startsWith("childNodes_")) continue;
                child = (Node)entry.getValue();
                this.removeNode(child);
                map = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(nodeComp);
                entries = map.entrySet().iterator();
            }
            SCAHelper.getSCAHelper().deleteComponent(nodeComp);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return true;
    }

    public void setInitialNode(Node initial) throws CoreException {
        try {
            this.initialNode = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)initial, "service");
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public List<Node> getAllNodes() throws CoreException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            List comps = SCAHelper.getSCAHelper().getComponents(this.getComponent());
            for (Component component : comps) {
                try {
                    if (!(component.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)component.getFcInterface("service"));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return nodes;
    }

    public List<Scope> getAllScopes() throws CoreException {
        ArrayList<Scope> scope = new ArrayList<Scope>();
        try {
            scope.add(this);
            List comps = SCAHelper.getSCAHelper().getAllSubComponents(this.getComponent());
            for (Component component : comps) {
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    scope.add((Scope)component.getFcInterface("service"));
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return scope;
    }

    public Node getNodeByName(String name) throws CoreException {
        Node res = null;
        try {
            List comps = SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), name);
            ArrayList<Node> nodes = new ArrayList<Node>();
            if (comps != null) {
                for (Component comp : comps) {
                    if (!(comp.getFcInterface("service") instanceof Node)) continue;
                    nodes.add((Node)comp.getFcInterface("service"));
                }
            }
            if (nodes.size() > 1) {
                throw new CoreException("Several node components are the same name");
            }
            if (nodes.size() > 0) {
                res = (Node)nodes.get(0);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void linkedNodeAndFunctionnalBehaviour(Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)behaviour, "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.fine(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void unlinkedNodeAndFunctionnalBehaviour(Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)behaviour, "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().deleteBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            log.fine(e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public Node unlinkBrotherNodes(Node sourceNode, Node targetNode) throws CoreException {
        Node res = null;
        try {
            Map mapOfBindings = SCAHelper.getSCAHelper().getListOfBindings(sourceNode.getComponent());
            Node afterNode = null;
            String afterName = null;
            for (Map.Entry e : mapOfBindings.entrySet()) {
                if (!((String)e.getKey()).startsWith("outgoingNodes")) continue;
                afterName = (String)e.getKey();
                afterNode = (Node)e.getValue();
                break;
            }
            res = afterNode;
            List cs = SCAHelper.getSCAHelper().getClientComponentsLinkedToServerInterfacesOfComponent(this.getComponent(), (Interface)sourceNode.getComponent().getFcInterface("service"));
            ArrayList<Boolean> started = new ArrayList<Boolean>();
            for (Component css : cs) {
                if (!SCAHelper.getSCAHelper().isStarted(css)) {
                    SCAHelper.getSCAHelper().startComponent(css);
                    started.add(Boolean.FALSE);
                    continue;
                }
                started.add(Boolean.TRUE);
            }
            Binding b = new Binding(afterName, (Interface)afterNode.getComponent().getFcInterface("service"));
            ArrayList<Binding> bindToDelete = new ArrayList<Binding>();
            bindToDelete.add(b);
            SCAHelper.getSCAHelper().deleteBindings(sourceNode.getComponent(), bindToDelete);
            int i = 0;
            for (Component css : cs) {
                if (!((Boolean)started.get(i)).booleanValue()) {
                    SCAHelper.getSCAHelper().stopComponent(css);
                }
                ++i;
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public void linkedBrotherNodes(Node sourceNode, Node targetNode) throws CoreException {
        try {
            Component sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)sourceNode, "service");
            Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)targetNode, "service");
            if (sourceComp == null || targetComp == null) {
                throw new CoreException("Impossible to link brother nodes");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("incomingNodes_" + this.formatCounter(cpt_incomingNode), (Interface)sourceComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
            ++cpt_incomingNode;
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("outgoingNodes" + this.formatCounter(cpt_outgoingNode), (Interface)targetComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(sourceComp, listOfBindings);
            ++cpt_outgoingNode;
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void linkedChildNodeToParent(Node parentNode, Node childNode) throws CoreException {
        try {
            Component parentComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)parentNode, "service");
            Component childComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)childNode, "service");
            if (parentComp == null || childComp == null) {
                throw new CoreException("Impossible to link parent and children node");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childNodes_" + this.formatCounter(cpt_childsNode), (Interface)childComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(parentComp, listOfBindings);
            ++cpt_childsNode;
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("parentNode", (Interface)parentComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(childComp, listOfBindings);
            SCAContentController scacc = (SCAContentController)childComp.getFcInterface("/sca-content-controller");
            NodeImpl nodeContent = null;
            try {
                nodeContent = (NodeImpl)((Object)scacc.getFcContent());
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (nodeContent.getParentNode() == null) {
                nodeContent.setParentNode(parentNode);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void linkedChildNodeToParent2(Node parentNode, Node childNode) throws CoreException {
        try {
            Component parentComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)parentNode, "service");
            Component childComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)childNode, "service");
            if (parentComp == null || childComp == null) {
                throw new CoreException("Impossible to link parent and children node");
            }
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childNodes_" + this.formatCounter(cpt_childsNode), (Interface)childComp.getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(parentComp, listOfBindings);
            ++cpt_childsNode;
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void linkedExecutableElement2Execution(Node source, Execution exe) throws CoreException {
        try {
            Component sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)source, "service");
            Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getComponent(), (Interface)exe, "service");
            if (exeComp == null || sourceComp == null) {
                throw new CoreException("Impossible to link the axecution and the target node");
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public Variable findVariable(String name) throws CoreException {
        Variable v = null;
        v = this.variables.get(name);
        if (v == null) {
            Scope current = this.getParentScope(this);
            while (v == null && current != null) {
                v = (Variable)current.getVariables().get(name);
                current = this.getParentScope(current);
            }
        }
        return v;
    }

    public final void getInScopeVariables(Map<String, Variable> result) throws CoreException {
        Scope parentScope = this.getParentScope();
        if (parentScope != null) {
            parentScope.getInScopeVariables(result);
        }
        result.putAll(this.getVariables());
    }

    public Map<String, Variable> getInScopeVariables() throws CoreException {
        HashMap<String, Variable> inScopeVariables = new HashMap<String, Variable>();
        this.getInScopeVariables(inScopeVariables);
        return inScopeVariables;
    }

    public List<CorrelationGroup> findCorrelationGroups(String name) throws CoreException {
        ArrayList<CorrelationGroup> res = new ArrayList<CorrelationGroup>();
        for (CorrelationGroup correlationGroup : this.correlationGroups) {
            if (correlationGroup.getCorrelations().get(name) == null) continue;
            res.add(correlationGroup);
        }
        Scope current = this.getParentScope(this);
        if (current != null) {
            res.addAll(current.findCorrelationGroups(name));
            current = this.getParentScope(current);
        }
        return res;
    }

    public Partner findPartner(String partnerName) throws CoreException {
        Partner ep = null;
        ep = this.partners.get(partnerName);
        if (ep == null) {
            Scope current = this.getParentScope(this);
            while (ep == null && current != null) {
                ep = (Partner)current.getPartners().get(partnerName);
                current = this.getParentScope(current);
            }
        }
        return ep;
    }

    public <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass) throws CoreException {
        return ScopeImpl.findBehaviours(behaviourClass, this.getComponent(), false);
    }

    public <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, boolean ignoreStoppedComponent) throws CoreException {
        return ScopeImpl.findBehaviours(behaviourClass, this.getComponent(), ignoreStoppedComponent);
    }

    public static <B extends Behaviour> List<B> findBehaviours(Class<B> behaviourClass, Component comp, boolean ignoreStopComponent) throws CoreException {
        ArrayList<Behaviour> behaviours = new ArrayList<Behaviour>();
        HashSet<Object> behavioursSet = new HashSet<Object>();
        try {
            List list = SCAHelper.getSCAHelper().getAllSubComponents(comp);
            for (Component component : list) {
                boolean isStarted = SCAHelper.getSCAHelper().isStarted(component);
                try {
                    Behaviour behaviour = (Behaviour)component.getFcInterface("service");
                    if (InstanceOfUtil.isClassExtendOfClass2found(behaviour.getClass(), behaviourClass)) {
                        if (ignoreStopComponent) {
                            SCAHelper.getSCAHelper().startComponent(component);
                            behavioursSet.add(behaviour);
                        } else if (isStarted) {
                            behavioursSet.add(behaviour);
                        }
                    }
                }
                catch (NoSuchInterfaceException behaviour) {
                }
                catch (ClassCastException behaviour) {
                    // empty catch block
                }
                try {
                    if (!(component.getFcInterface("service") instanceof Scope)) continue;
                    boolean wasStarted = SCAHelper.getSCAHelper().isStarted(component);
                    if (!wasStarted) {
                        SCAHelper.getSCAHelper().startComponent(component);
                    }
                    behavioursSet.addAll(ScopeImpl.findBehaviours(behaviourClass, component, ignoreStopComponent));
                    if (wasStarted) continue;
                    SCAHelper.getSCAHelper().stopComponent(component);
                }
                catch (NoSuchInterfaceException noSuchInterfaceException) {
                    // empty catch block
                }
            }
        }
        catch (SCAException sCAException) {
            throw new CoreException((Throwable)sCAException);
        }
        for (Behaviour behaviour : behavioursSet) {
            behaviours.add(behaviour);
        }
        return behaviours;
    }

    public void setVariable(Variable v) throws CoreException {
        ScopeImpl current = this;
        Variable var = (Variable)current.getVariables().get(v.getName());
        if (var == null) {
            while (var == null && current != null) {
                var = (Variable)current.getVariables().get(v.getName());
                current = this.getParentScope();
            }
        }
        if (current != null) {
            current.getVariables().put(v.getName(), v);
        } else {
            this.getVariables().put(v.getName(), v);
        }
    }

    public Scope getParentScope() throws CoreException {
        Process parent = null;
        try {
            Component parentComp;
            if (!(this instanceof Process) && (parentComp = SCAHelper.getSCAHelper().getParent(this.getComponent())) != null) {
                try {
                    parent = (Process)parentComp.getFcInterface("service");
                }
                catch (NoSuchInterfaceException e) {
                    parent = (Scope)parentComp.getFcInterface("service");
                }
                catch (ClassCastException e) {
                    parent = (Scope)parentComp.getFcInterface("service");
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parent;
    }

    private Scope getParentScope(Scope child) throws CoreException {
        Scope parent = null;
        try {
            Component parentComp;
            if (!(child instanceof Process) && (parentComp = SCAHelper.getSCAHelper().getParent(child.getComponent())) != null) {
                parent = (Scope)parentComp.getFcInterface("service");
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
        }
        catch (SCAException sCAException) {
            // empty catch block
        }
        return parent;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        log = logger;
    }

    private String formatCounter(int cpt) {
        String res = "";
        res = cpt < 10 ? "000" + cpt : (cpt < 100 ? "00" + cpt : (cpt < 1000 ? "0" + cpt : String.valueOf(cpt)));
        return res;
    }

    public Map<String, Partner> getPartners() {
        return this.partners;
    }

    public List<CorrelationGroup> getCorrelationGroups() {
        return this.correlationGroups;
    }

    public final Map<Fault, Scope> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }

    public final void addException(Fault fault, Scope faultScope) {
        this.exceptions.put(fault, faultScope);
    }

    public Exception getException() {
        return this.faultScope;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public void setException(Exception faultScope) {
        System.err.println("$$$$$$$$$$$$$$$$$ setException(" + (faultScope == null ? "null" : faultScope.getClass()) + ") on " + this.getName());
        this.faultScope = faultScope;
    }

    public void setTerminationHandler(TerminationHandler th) {
        this.terminationHandler = th;
    }

    public TerminationHandler getTerminationHandler() {
        return this.terminationHandler;
    }

    public final ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    public final void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public final PartnerEvaluator getPartnerEvaluator() {
        return this.partnerEvaluator;
    }

    public final void setPartnerEvaluator(PartnerEvaluator partnerEvaluator) {
        this.partnerEvaluator = partnerEvaluator;
    }
}

