/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractSimpleBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.SenderBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingInputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.BindingOutputMessageAdapter;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={SenderBehaviour.class}, names={"service"})
public class SenderBehaviourImpl
extends AbstractSimpleBehaviourImpl
implements SenderBehaviour {
    @Property(name="kind", required=true)
    private SenderBehaviour.Kind kind;
    @Property(name="inputVariableName", required=true)
    private String inputVariableName;
    @Property(name="outputVariableName", required=true)
    private String outputVariableName;
    @Property(name="partnerName", required=false)
    private String partnerName;
    @Property(name="operationName", required=false)
    private String operationName;
    @Property(name="interfaceName", required=false)
    private QName interfaceName;
    @Property(name="outputMessageAdapter", required=false)
    private BindingOutputMessageAdapter outputMessageAdapter;
    @Property(name="inputMessageAdapter", required=false)
    private BindingInputMessageAdapter inputMessageAdapter;
    @Property(name="faultHandler", required=false)
    private FaultHandler faultHandler;
    @Property(name="isReply", required=false)
    private boolean isReply = false;

    private void sendTo(Execution execution, Message message, String address, Map<Partner, Map<String, ExternalContext>> context, boolean isReply) throws CoreException {
        Process p = execution.getCurrentTarget().getProcess();
        p.getEngine().sendTo(message, address, context, isReply);
    }

    private Message sendSyncTo(Execution execution, Message request, String address, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        Process p = execution.getCurrentTarget().getProcess();
        return p.getEngine().sendSyncTo(request, address, context);
    }

    public CorrelationMatcher getCorrelationMatcher() {
        return null;
    }

    public void setCorrelationMatcher(CorrelationMatcher correlationMatcher) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doExecute(Execution execution) {
        Scope scope = this.getNode().getScope();
        Variable inputVariable = scope.findVariable(this.inputVariableName);
        if (inputVariable == null) {
            throw new CoreException("Input Variable " + this.inputVariableName + " not found in behaviour: " + this.getName());
        }
        if (this.kind == null) {
            throw new CoreException("Kind cannot be null");
        }
        if (this.partnerName != null) {
            Partner partner = scope.findPartner(this.partnerName);
            if (partner == null) {
                throw new CoreException("Provider Endpoint cannot be null");
            }
            boolean isBindingStyleRpc = false;
            BindingMessageAdapter.Direction direction = BindingMessageAdapter.Direction.REQUEST;
            try {
                String endpointName = scope.getPartnerEvaluator().getEndpointName(partner.getValue(execution));
                QName serviceName = scope.getPartnerEvaluator().getServiceName(partner.getValue(execution));
                if (this.kind == SenderBehaviour.Kind.ASYNCHRONOUS) {
                    this.log.fine("asynchronous send");
                    Message outputMessage = null;
                    if (this.outputMessageAdapter != null) {
                        isBindingStyleRpc = this.outputMessageAdapter.isBindingStyleRpc(endpointName, serviceName, this.interfaceName, this.operationName);
                        direction = this.isReply ? BindingMessageAdapter.Direction.RESPONSE : BindingMessageAdapter.Direction.REQUEST;
                        outputMessage = this.outputMessageAdapter.adaptToBindingOutput(execution, inputVariable, endpointName, serviceName, this.interfaceName, this.operationName, direction, isBindingStyleRpc);
                        this.log.fine("adapt the message: " + outputMessage);
                    }
                    this.sendTo(execution, outputMessage, this.getNode().getScope().getPartnerEvaluator().getAddress(partner.getValue(execution)), this.getNode().getProcess().getExternalContexts(), this.isReply);
                    return;
                }
                if (this.kind != SenderBehaviour.Kind.SYNCHRONOUS) return;
                this.log.fine("synchronous send");
                Variable outputVariable = scope.findVariable(this.outputVariableName);
                if (outputVariable == null) {
                    throw new CoreException("Output Variable " + this.outputVariableName + " not found in behaviour: " + this.getName());
                }
                Message outputMessage = null;
                isBindingStyleRpc = this.outputMessageAdapter.isBindingStyleRpc(endpointName, serviceName, this.interfaceName, this.operationName);
                outputMessage = this.outputMessageAdapter.adaptToBindingOutput(execution, inputVariable, endpointName, serviceName, this.interfaceName, this.operationName, direction, isBindingStyleRpc);
                this.log.fine("operation name : " + this.operationName);
                Message response = this.sendSyncTo(execution, outputMessage, scope.getPartnerEvaluator().getAddress(partner.getValue(execution)), this.getNode().getProcess().getExternalContexts());
                this.inputMessageAdapter.adaptFromBindingInput(execution, response, outputVariable, BindingMessageAdapter.Direction.RESPONSE, isBindingStyleRpc);
                this.log.fine("set outpuvariable " + outputVariable.getName() + " with value:\n" + new XMLOutputter(Format.getPrettyFormat()).outputString((Element)outputVariable.getValue(execution)));
                return;
            }
            catch (CoreException e) {
                if (this.faultHandler != null) {
                    CoreException modelException = this.faultHandler.getBPELExceptionFromGenericException(scope, e, direction, isBindingStyleRpc);
                    if (modelException == null) throw e;
                    throw modelException;
                }
                this.log.warning("exception handler is null");
                throw e;
            }
        } else {
            this.log.fine("the provider Endpoint Key is null");
        }
    }
}

