/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.time;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.time.TimerFinishedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class WaitingThreadPool {
    private static Logger log = Logger.getLogger(WaitingThreadPool.class.getSimpleName());
    private static WaitingThreadPool instance;
    private static Map<Execution, List<WaitingThread>> threads;
    private static Map<Execution, List<CoreException>> exceptions;

    static {
        threads = Collections.synchronizedMap(new HashMap());
        exceptions = Collections.synchronizedMap(new HashMap());
    }

    private WaitingThreadPool() {
    }

    public static synchronized void addWaitingThread(Execution exec, WaitBehaviour waitBehaviour, long timeToWait) {
        WaitingThreadPool waitingThreadPool = WaitingThreadPool.getInstance();
        waitingThreadPool.getClass();
        WaitingThread wt = waitingThreadPool.new WaitingThread(exec, waitBehaviour, timeToWait);
        if (!threads.containsKey(exec)) {
            threads.put(exec, new ArrayList());
        }
        threads.get(exec).add(wt);
        log.finest("new Waiting thread for " + waitBehaviour.getName() + " " + timeToWait);
        wt.start();
    }

    public static synchronized void removeWaitingThread(Execution exec, WaitBehaviour wb) {
        if (threads.containsKey(exec)) {
            WaitingThread toBeRemoved = null;
            for (WaitingThread wt : threads.get(exec)) {
                if (!wt.behaviour.equals(wb)) continue;
                toBeRemoved = wt;
                break;
            }
            threads.get(exec).remove(toBeRemoved);
        }
    }

    private synchronized void onWaitTermination(Execution exec, WaitBehaviour b) {
        if (threads.containsKey(exec)) {
            threads.get(exec).remove(Thread.currentThread());
            try {
                exec.getCurrentScope().getProcess().getEngine().onTimerFinish(exec, new TimerFinishedEvent(exec, b));
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.addException(exec, e);
            }
        }
    }

    private void addException(Execution exec, CoreException e) {
        if (!exceptions.containsKey(exec)) {
            exceptions.put(exec, new ArrayList());
        }
        exceptions.get(exec).add(e);
    }

    private static WaitingThreadPool getInstance() {
        if (instance == null) {
            instance = new WaitingThreadPool();
        }
        return instance;
    }

    private class WaitingThread
    extends Thread {
        private Execution exec;
        private WaitBehaviour behaviour;
        private long time;

        protected WaitingThread(Execution exec, WaitBehaviour wb, long timeToWait) {
            this.time = timeToWait;
            this.behaviour = wb;
            this.exec = exec;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.time);
                log.finest("Sleep ended for " + this.behaviour.getName());
            }
            catch (InterruptedException e) {
                return;
            }
            WaitingThreadPool.this.onWaitTermination(this.exec, this.behaviour);
        }
    }
}

