/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractSimpleBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.AssignBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.AssignementExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = AssignBehaviour.class, names = "service")
@PolicySets("frascati:scaEasyPrimitive")
public class AssignBehaviourImpl extends AbstractSimpleBehaviourImpl implements AssignBehaviour {

    private Logger log = Logger.getLogger(AssignBehaviourImpl.class.getSimpleName());

    @Property(name = "assignements", required = true)
    private List<AssignementExpression> assignements = new ArrayList<AssignementExpression>();

    @Override
    protected void doExecute(Execution execution) {
        for (final AssignementExpression assignement : this.assignements) {

            if ((assignement == null) || (assignement.getLeft() == null)) {
                throw new CoreException("The left assignement is null");
            }
            Assigner assigner = getNode().getProcess().getAssigner();

            if (assigner == null) {
                throw new CoreException("Error: the assigner cannot be null");
            }

            // realized affectation
            this.log.fine("set " + assignement.getRight() + " in " + assignement.getLeft());

            assigner.affect(execution, assignement.getLeft(), assignement.getRight());

        }
    }

}
