/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.soa.message;

import java.io.IOException;
import java.io.StringReader;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Body;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class BodyImpl implements Body {

	private Element elmt;
	
	public BodyImpl() {
		
	}

    @Override
    public Element getPayload() {
        return this.elmt;
    }

    @Override
    public String getPayloadAstring() {
        XMLOutputter xmlOutputter = new XMLOutputter();
        return xmlOutputter.outputString(elmt);
    }
    
    
    @Override
    public void setPayload(Element doc) {
        this.elmt = doc;
    }

    @Override
    public boolean hasPayload() {
        return this.getPayload() != null;
    }

    @Override
    public void setPayloadAsString(String doc) {
        SAXBuilder saxBuilder = new SAXBuilder();
        try {
            this.setPayload(saxBuilder.build(new StringReader(doc)).getRootElement());
        } catch (JDOMException e) {
            throw new CoreException(e);
        } catch (IOException e) {
            throw new CoreException(e);
        }
    }
	
	
}
