/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class SequencePatternTest
extends AbstractCoreTest {
    @Test
    public void testSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("start", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("a", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("b", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("c", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testEmptySequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        ArrayList childNodes = new ArrayList();
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testNullSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", null, (Scope)process);
        process.setInitialNode(initial);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testSequencePatternWithNodeAround() throws CoreException, NoSuchInterfaceException, InterruptedException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        Node start = process.createNode("start", EmptyBehaviourImpl.class, null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("a", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("b", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("c", EmptyBehaviourImpl.class, null));
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        Node seq = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(start);
        process.linkedBrotherNodes(start, seq);
        process.linkedBrotherNodes(seq, end);
        Execution main = core.getEngine().run(process);
        this.checkExecutionEndedProperly(main);
    }
}

