/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.Iterator;
import java.util.List;

import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.IfBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=IfBehaviour.class,names="service")
public class IfBehaviourImpl extends AbstractComplexBehaviourImpl implements IfBehaviour {

	@Property(name="conditions", required=true)
	private List<Expression> conditions;


	@Override
	protected State executeOnInactive(Execution execution) throws CoreException {
		assert conditions != null;
		assert !conditions.isEmpty();

		final Iterator<Expression> itExpressions = this.conditions
				.iterator();
		final Iterator<Node> itNodes = getNode().getChildNodes().iterator();

		Expression expression = null;
		Node selectedChild = null;
		boolean find = false;
		while ((itExpressions.hasNext()) && (!find)) {
			expression = itExpressions.next();
			selectedChild = itNodes.next();
			Boolean cond = getNode().getScope().
					getExpressionEvaluator().evaluateAsBoolean(execution, expression);

			this.log.fine("evaluate conditionnal expression: \n" + expression + " => return: " + cond);
			if (cond != null && cond == true) {
				selectNextNodeToExecute(execution, selectedChild);
				find = true;
			}
		}

		// the else case...
		if ((!find) && (itNodes.hasNext())) {
			selectedChild = itNodes.next();
			selectNextNodeToExecute(execution, selectedChild);
			find = true;
		}
		return State.ACTIVITY_STARTED;
	}


}
