/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.tools;

import java.util.Map;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=Sender.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class SysoutSenderImpl extends AbstractSenderImpl implements Sender {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(SysoutSenderImpl.class.getName());

	/**
	 * Default constructor
	 * 
	 * @throws CoreException
	 */
	public SysoutSenderImpl() {
		super();
	}

	@Override
	public void sendTo(final Message message,
			String address, final Map<Partner, Map<String,ExternalContext>> context, boolean isReply)
			throws CoreException {
		final Message externalMessage = message;
		System.out.println("MESSAGE SENT BY CORE: \n"
				+ externalMessage);
	}

    @Override
	public Message sendSyncTo(final Message message,
	        String address, Map<Partner, Map<String,ExternalContext>> context)
			throws CoreException {
		final Message externalMessage = message;
		System.out.println("MESSAGE SENT BY CORE: \n"
				+ externalMessage);

		final Message internalMessage = message;
		System.out.println("MESSAGE RECEIVED BY CORE: \n"
				+ internalMessage);
		return internalMessage;
	}

	@Override
	public void setLog(final Logger logger) {
		super.setLog(logger);
		this.log = logger;
	}

	public void sendTo(CoreException e, Map<Partner, Map<String,ExternalContext>> context) {
		throw new UnsupportedOperationException();
	}

	
}
