/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.marshalling;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.jdom.input.DOMBuilder;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ViperMessageMarshallingTest {
    private Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private static final String ns = "http://easyviper/test";

    private Message createInternalMessage() throws CoreException, ParserConfigurationException {
        MessageImpl mess = null;
        mess = new MessageImpl("myOperation");
        QName qnameTest = new QName(ns, "myVar");
        mess.setQName(qnameTest);
        mess.setEndpoint("myEndpoint");
        mess.setService(new QName(ns, "myService"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().newDocument();
        Element content = doc.createElementNS("urn:namespaceMessageContent", "content");
        doc.appendChild(content);
        Element root = doc.createElementNS("urn:namespaceMessageContent", "root");
        content.appendChild(root);
        Element node1 = doc.createElementNS("urn:namespaceMessageContent", "node1");
        node1.setTextContent("node1 text content");
        root.appendChild(node1);
        DOMBuilder domBuilder = new DOMBuilder();
        mess.getBody().setPayload(domBuilder.build(doc.getDocumentElement()));
        return mess;
    }

    @Test
    public void testCreateMarshalling() {
        this.log.finest("Creation test ...");
        try {
            Message mess = this.createInternalMessage();
            Assert.assertEquals((Object)new QName(ns, "myVar"), (Object)mess.getQName());
        }
        catch (CoreException e) {
            e.printStackTrace();
            Assert.fail((String)("=>testCreate: \n" + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            Assert.fail((String)("=>testCreate: \n" + e.getMessage()));
        }
    }
}

