/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import org.objectweb.fractal.api.NoSuchInterfaceException;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ScopeBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.FaultHandler;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = ScopeBehaviour.class, names = "service")
public class ScopeBehaviourImpl extends AbstractComplexBehaviourImpl implements ScopeBehaviour {

    public ScopeBehaviourImpl() {
    }

    private final Scope getScopeWithHack() {
        Scope scope;
        try {
            scope = (Scope) getNode().getComponent().getFcInterface("service");
        } catch (NoSuchInterfaceException e) {
            throw new CoreException(e);
        }
        return scope;
    }

    @Override
    protected final State executeOnStarted(Execution execution) throws CoreException {
        assert execution != null;
        Scope scope = getScopeWithHack();
        execution.enterScope(scope);

        if (scope.getException() != null) {
            System.err.println("EXC!!! " + System.identityHashCode(scope));
            assignCaughtExceptionVariable(execution, (CoreException) scope.getException());
        }

        if (scope.getInitialNode() != null) {
            selectNextNodeToExecute(execution, scope.getInitialNode());
        }
        return State.ACTIVITY_ENDED;
    }

    private void assignCaughtExceptionVariable(Execution execution, CoreException caughtException) {
        Scope scope = getScopeWithHack();

        if (caughtException.getFaultVariableName() == null) {
            // catch all, nothing to do.
            return;
        }

        Scope parentScope = scope.getParentScope();
        Fault matchedFault = null;
        for (Fault matchableFault : parentScope.getExceptions().keySet()) {
            if ((matchableFault.getFaultHandler() != null)
                    && (matchableFault.getFaultHandler().match(execution, matchableFault,
                            (CoreException) caughtException, scope))) {
                matchedFault = matchableFault;

            }
        }
        assert matchedFault != null;
        Variable caughtExceptionVariable = scope.findVariable(caughtException
                .getFaultVariableName());
        assert caughtExceptionVariable != null;
        FaultHandler faultHandler = matchedFault.getFaultHandler();
        assert faultHandler != null;

        faultHandler.assignExceptionVariable(execution, caughtException, caughtExceptionVariable);
    }

    @Override
    protected final State executeOnEnded(Execution execution) throws CoreException {
        Scope scope = getScopeWithHack();
        for (Scope faultScope : scope.getExceptions().values()) {
            if (faultScope.getException() != null) {
                faultScope.setException(null);
                
                faultScope.getBehaviour().reset();
            }
        }
        execution.leaveScope();
        return super.executeOnEnded(execution);

    }

    @Override
    public void reset() {
        super.reset();
        Scope scope = getScopeWithHack();
        scope.getInitialNode().getBehaviour().reset();
    }

}
