/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.configuration;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class ConfigurationEngineImpl implements ConfigurationEngine {

	private Integer autoFushMessageFrequency = 0;
	
	private Integer autoTrashProcessFrequency = 0;
	
	private Boolean explorer = false;

    private boolean singleThreadedExecution = false;
    
    private boolean synchronousRun;
    
	
	private List<Class<? extends Service>> additionnalServices = new ArrayList<Class<? extends Service>>();
	
	
	public void setSingleThreadedExecution(boolean singleThreadedExecution) {
	    this.singleThreadedExecution = singleThreadedExecution;
	}

	public final boolean getSingleThreadedExecution() {
	    return singleThreadedExecution;
	}
	
	
	public Integer getAutoFlushMessageFrequency() {
		return this.autoFushMessageFrequency;
	}

	public Integer getAutoTrashProcessFrequency() {
		return this.autoTrashProcessFrequency;
	}

	public Boolean getExplorer() {
		return this.explorer;
	}

	public void setAutoFlushMessageFrequency(Integer frequency) {
		this.autoFushMessageFrequency = frequency;
	}

	public void setAutoTrashProcessFreqeuency(Integer frequency) {
		this.autoTrashProcessFrequency = frequency;
	}

	public void setExplorer(Boolean explorer) {
		this.explorer = explorer;
	}

	public List<Class<? extends Service>> getAdditionnalServices() {
		return this.additionnalServices;
	}

	public void setAdditionnalServices(List<Class<? extends Service>> services) {
		this.additionnalServices = services;
	}
	
    public boolean getSynchronousRun() {
        return this.synchronousRun;
    }
    
    public void setSynchronousRun(boolean synchronousRun) {
        this.synchronousRun = synchronousRun;
    }


}
