/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.registry.ProcessInstanceRegistry;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.ServiceManager;
import com.ebmwebsourcing.easyviper.core.api.engine.time.TimerFinishedEvent;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.api.tools.PoolOfProcessForkers;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionThread;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.engine.registry.MemoryProcessInstanceRegistryImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.thread.service.ServiceManagerImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;
import com.ebmwebsourcing.easyviper.core.impl.services.AutoFlushMessageServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.api.AutoTrashProcessService;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.impl.AutoTrashProcessServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Property;
import org.ow2.frascati.tinfi.control.content.SCAExtendedContentController;

@Scope(value="COMPOSITE")
@Service(value={Engine.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class EngineImpl
extends SCAComponentImpl
implements Engine {
    Logger log = Logger.getLogger(EngineImpl.class.getSimpleName());
    private static final SimpleUUIDGenerator uuidGenerator = new SimpleUUIDGenerator();
    @Reference(name="externalEnv", required=false)
    protected ExternalEnvironment externalEnvironment;
    @Reference(name="model", required=false)
    private Model model;
    @Property(name="processInstanceRegistry", required=true)
    private ProcessInstanceRegistry processInstanceRegistry = new MemoryProcessInstanceRegistryImpl(this);
    @Property(name="serviceManager", required=true)
    private ServiceManager serviceManager = new ServiceManagerImpl(this);
    private PoolOfProcessForkers poolOfProcessForkers = new PoolOfProcessForkers();
    private ConfigurationEngine configuration = null;

    public synchronized Process createNewEmptyProcessInstance(QName uniqueProcessName, ProcessDefinition processDefinition) throws CoreException {
        this.log.fine("start createNewEmptyProcessInstance");
        this.checkModel();
        Process process = CreationPatternFactory.getInstance().createProcessPattern(uniqueProcessName.toString(), this);
        Component processDefinitionComp = process.getComponent();
        try {
            process = (Process)processDefinitionComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
            throw new CoreException((Throwable)e);
        }
        if (this.model == null) {
            this.log.fine("store the process instance in registry in instance registry");
            ProcessKeyImpl key = new ProcessKeyImpl(uniqueProcessName, null, null);
            ArrayList<ProcessKeyImpl> keys = new ArrayList<ProcessKeyImpl>(1);
            keys.add(key);
            process.setProcessKeys(keys);
            this.processInstanceRegistry.storeProcessInstance((ProcessKey)key, process);
        } else {
            List keys = this.model.getRegistry().createKeys(processDefinition);
            this.log.fine("Number of keys: " + keys.size());
            for (ProcessKey key : keys) {
                this.log.fine("key put in process instances map: " + key);
                this.getProcessInstanceRegistry().storeProcessInstance(key, process);
            }
            process.setProcessKeys(keys);
        }
        this.log.fine("end of createNewEmptyProcessInstance");
        return process;
    }

    private void checkModel() throws CoreException {
        try {
            if (this.model == null) {
                Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
                Core core = (Core)coreComp.getFcInterface("service");
                this.model = core.getModel();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    private void checkExternalEnvironment() throws CoreException {
        try {
            if (this.externalEnvironment == null) {
                Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
                Core core = (Core)coreComp.getFcInterface("service");
                this.externalEnvironment = core.getExternalEnvironment();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public synchronized void accept(Message internalMessage, ExternalContext context) throws CoreException {
        this.checkModel();
        Execution validExecution = this.acceptInternalMessage(internalMessage);
        if (validExecution == null) {
            this.log.fine("no process found => store the received message");
            AutoFlushMessageServiceImpl autoflush = (AutoFlushMessageServiceImpl)this.serviceManager.getService(AutoFlushMessageServiceImpl.class);
            autoflush.addMessagesInRegistry(internalMessage, context);
        } else {
            Process process = validExecution.getCurrentTarget().getProcess();
            Partner endpoint = this.findEndpointFromMessage(internalMessage, process);
            this.log.fine("set the context: " + context + " into process instance " + process.getName());
            process.addExternalContext(endpoint, internalMessage.getOperationName(), context);
            this.restartExecution(validExecution, context);
        }
    }

    private final Collection<String> getAllActiveThreadNames() {
        HashSet<String> result = new HashSet<String>();
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Thread t : threads.keySet()) {
            result.add(t.getName());
        }
        return result;
    }

    private void restartProcess(Process process, ExternalContext context) throws CoreException {
        assert (process != null);
        Execution execution = process.getExecution();
        this.restartExecution(execution, context);
    }

    public void restartExecution(Execution execution, ExternalContext context) {
        Collection<String> threadNames = this.getAllActiveThreadNames();
        if (!threadNames.contains(String.valueOf(execution.getName()))) {
            this.log.fine("Spawning (or respawning) thread for execution " + execution.getName());
            ExecutionThread processThread = new ExecutionThread(execution, this.getCore().getExternalEnvironment(), this.log);
            if (this.configuration.getSingleThreadedExecution()) {
                processThread.run();
            } else {
                processThread.start();
            }
        }
    }

    private final Execution findFirstAvailableExecution(Message internalMessage) throws CoreException {
        assert (this.processInstanceRegistry != null);
        Execution validExecution = null;
        List processes = new ArrayList();
        this.log.fine("try to find an available instance");
        processes = this.processInstanceRegistry.getProcessInstances(internalMessage);
        assert (processes != null);
        this.log.fine("number of potential process: " + processes.size());
        if (processes.isEmpty()) {
            return null;
        }
        ArrayList<Execution> possibleExecution = new ArrayList<Execution>();
        boolean reinitOrSuspended = false;
        Iterator it = processes.iterator();
        while (it.hasNext()) {
            Process process = (Process)it.next();
            reinitOrSuspended = false;
            try {
                this.log.fine("test process: " + process.getName());
                if (process.hasExecution() && process.getExecution().getState() == Execution.State.ENDED) {
                    this.log.fine("reinit and restart an older instance: " + process.getName());
                    process.end(true);
                    this.run(process);
                    reinitOrSuspended = true;
                } else {
                    reinitOrSuspended = true;
                }
            }
            catch (CoreException e) {
                process.setUnstable(true);
                processes.remove(process);
                it = processes.iterator();
                AutoTrashProcessService autoTrash = (AutoTrashProcessService)this.serviceManager.getService(AutoTrashProcessServiceImpl.class);
                autoTrash.addUninstableProcessInstance(process);
            }
            if (!reinitOrSuspended) continue;
            try {
                Execution exec = this.injectMessageInProcessInstance(process, internalMessage);
                if (exec == null) continue;
                System.err.println("---10");
                this.log.fine("available instance found => restart the process " + process.getName());
                possibleExecution.add(exec);
                break;
            }
            catch (CoreException e) {
                this.log.severe("Error injecting a message in process " + process.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (possibleExecution.size() > 0) {
            System.err.println("---12");
            validExecution = (Execution)possibleExecution.get(0);
        }
        return validExecution;
    }

    private Execution acceptInternalMessage(Message internalMessage) throws CoreException {
        Execution validExecution = this.findFirstAvailableExecution(internalMessage);
        if (validExecution == null) {
            this.log.fine("no available instance found");
            if (this.model != null) {
                ProcessKeyImpl key = new ProcessKeyImpl();
                key.setEndpoint(internalMessage.getEndpoint());
                key.setService(internalMessage.getService());
                ProcessDefinition definition = this.model.getRegistry().getProcessDefinition((ProcessKey)key);
                if (definition == null) {
                    throw new CoreException("Impossible to find definition corresponding to this key: " + key);
                }
                if (this.isCreateInstance(definition, internalMessage)) {
                    Process process = this.model.getCompiler().compile(definition);
                    if (process != null) {
                        this.log.fine("run the process...");
                        this.run(process);
                        this.log.fine("inject the message in process");
                        Execution exec = this.injectMessageInProcessInstance(process, internalMessage);
                        if (exec != null) {
                            validExecution = exec;
                        }
                    } else {
                        this.log.fine("no process definition found concerned by the received message: " + key);
                    }
                }
            }
        }
        return validExecution;
    }

    private Execution injectMessageInProcessInstance(Process process, Message internalMessage) throws CoreException {
        Execution res = null;
        while (process.getExecution() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.log.warning("Wait execution is started");
            }
        }
        Map execs = process.getExecution().getSuspendedExecutions();
        this.log.fine("list of execution to try: " + execs);
        for (Execution exec : execs.values()) {
            try {
                this.log.fine("try to inject message in process " + process.getName() + " using execution " + exec.getName());
                if (exec.getCurrentTarget() instanceof Node) {
                    Node node = exec.getCurrentTarget();
                    if (node.getBehaviour() instanceof ReceiverBehaviour) {
                        ReceiverBehaviour receiverBehaviour = (ReceiverBehaviour)node.getBehaviour();
                        if (receiverBehaviour.getMessage() == null) {
                            receiverBehaviour.setMessage(internalMessage);
                            this.log.fine("message setted in receive behaviour: " + receiverBehaviour.getName());
                            boolean accept = receiverBehaviour.accept(exec, internalMessage);
                            if (accept) {
                                this.log.fine("accepted by receiver: " + receiverBehaviour.getName());
                                res = exec;
                                break;
                            }
                            this.log.fine("not accepted by receiver: " + receiverBehaviour.getName());
                            receiverBehaviour.setMessage(null);
                            continue;
                        }
                        this.log.fine("the receiver " + receiverBehaviour.getName() + " already contains a message");
                        continue;
                    }
                    throw new CoreException("Error: the node selected is not concerned by the received message " + node.getBehaviour().getName() + "::" + node.getClass().getCanonicalName());
                }
                throw new CoreException("Error: the execution selected is not concerned by the received message");
            }
            catch (CoreException e) {
                this.log.fine("Error in injectMessageInProcessInstance: " + e.getMessage());
            }
        }
        return res;
    }

    public void flushMessagesInRegistry() throws CoreException {
        this.log.fine("flush stored messages");
        AutoFlushMessageServiceImpl autoflush = (AutoFlushMessageServiceImpl)this.serviceManager.getService(AutoFlushMessageServiceImpl.class);
        autoflush.flushMessagesInRegistry();
    }

    public void sendTo(Message message, String address, Map<Partner, Map<String, ExternalContext>> context, boolean isReply) throws CoreException {
        this.checkExternalEnvironment();
        if (this.externalEnvironment.getSenders() == null || this.externalEnvironment.getSenders().size() <= 0) {
            throw new CoreException("Senders does not exist!!!");
        }
        ((Sender)this.externalEnvironment.getSenders().get(0)).sendTo(message, address, context, isReply);
    }

    public Message sendSyncTo(Message request, String address, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        Message res = null;
        this.checkExternalEnvironment();
        if (this.externalEnvironment.getSenders() == null || this.externalEnvironment.getSenders().size() <= 0) {
            throw new CoreException("Senders does not exist!!!");
        }
        res = ((Sender)this.externalEnvironment.getSenders().get(0)).sendSyncTo(request, address, context);
        return res;
    }

    public ProcessInstanceRegistry getProcessInstanceRegistry() {
        return this.processInstanceRegistry;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public void deleteProcess(Process process) throws CoreException {
        try {
            SCAExtendedContentController parentContentController = (SCAExtendedContentController)process.getExecution().getComponent().getFcInterface("/sca-content-controller");
            parentContentController.releaseFcContent((Object)process.getComponent(), true);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException("Delete process " + process.getName() + "failed. Caused by " + e.getMessage());
        }
    }

    public Core getCore() throws CoreException {
        Core res = null;
        try {
            Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Core)coreComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private boolean isCreateInstance(ProcessDefinition def, Message mess) throws CoreException {
        return this.model.getRegistry().isCreateInstance(def, mess);
    }

    public PoolOfProcessForkers getPoolOfProcessForkers() {
        return this.poolOfProcessForkers;
    }

    public Partner findEndpointFromMessage(Message mess, Process process) {
        Collection partners = process.getPartners().values();
        Iterator itEndpoints = partners.iterator();
        Partner endpoint = null;
        while (itEndpoints.hasNext()) {
            Partner current = (Partner)itEndpoints.next();
            Element key = current.getValue(process.getExecution());
            if (key == null) continue;
            String endpointName = process.getPartnerEvaluator().getEndpointName(key);
            QName serviceName = process.getPartnerEvaluator().getServiceName(key);
            if (endpointName == null || serviceName == null || !endpointName.equalsIgnoreCase(mess.getEndpoint()) || !serviceName.equals(mess.getService())) continue;
            endpoint = current;
            break;
        }
        return endpoint;
    }

    public Process findProcessFromName(String processInstanceName) {
        Process p = null;
        ProcessKeyImpl key = new ProcessKeyImpl();
        QName processDefinitionName = EngineImpl.extractProcessDefinitionName(processInstanceName);
        try {
            key = this.getCore().getModel().getRegistry().findProcessKey(processDefinitionName);
            List processInstances = this.getProcessInstanceRegistry().getProcessInstances((ProcessKey)key);
            for (Process process : processInstances) {
                if (!process.getName().equals(processInstanceName)) continue;
                p = process;
                break;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return p;
    }

    private static QName extractProcessDefinitionName(String processInstanceName) {
        int indexOf_ = processInstanceName.lastIndexOf("_");
        String valueOfQName = processInstanceName.substring(0, indexOf_);
        return QName.valueOf(valueOfQName);
    }

    public void onTimerFinish(Execution execution, TimerFinishedEvent e) throws CoreException {
        e.getWaitBehaviour().terminateWaiting(execution);
        this.restartProcess(e.getExecution().getCurrentScope().getProcess(), null);
    }

    private Execution doRun(Process process, boolean isStepByStep) throws CoreException {
        try {
            Component executionComp = SCAHelper.getSCAHelper().createNewComponent(ExecutionImpl.class.getName(), null);
            Execution execution = (Execution)executionComp.getFcInterface("service");
            SCAHelper.getSCAHelper().startComponent(executionComp);
            String executionName = "mainExec_" + uuidGenerator.getNewID();
            process.setProcessExecutionName(executionName);
            SCAHelper.getSCAHelper().changeName(executionComp, executionName);
            execution.setStepByStep(isStepByStep);
            SCAHelper.getSCAHelper().addComponent(executionComp, this.getComponent(), null);
            SCAHelper.getSCAHelper().startComponent(executionComp);
            execution.setInitialTarget((Node)process);
            process.setExecution(execution);
            this.restartProcess(process, null);
            return execution;
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public Execution run(Process process) throws CoreException {
        Execution execution = this.doRun(process, false);
        if (this.getConfiguration().getSynchronousRun()) {
            while (execution.getState() != Execution.State.ENDED && execution.getState() != Execution.State.CANCELLED) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return execution;
    }

    public Execution runStepByStep(Process process) throws CoreException {
        return this.doRun(process, true);
    }

    public ConfigurationEngine getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationEngine configuration) {
        this.configuration = configuration;
    }
}

