/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.thread.ConcurrentHashMapWithDefaults;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.fault.Fault;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.jdom.Element;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.types.Step;
import org.osoa.sca.annotations.Property;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Execution.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class ExecutionImpl
extends SCAComponentImpl
implements Execution {
    private Logger log = Logger.getLogger(ExecutionImpl.class.getSimpleName());
    @Property(name="stepByStep", required=true)
    private boolean stepByStep = false;
    private AtomicReference<Execution.State> currentState = new AtomicReference<Execution.State>(Execution.State.INACTIVE);
    private Node currentTarget;
    @Reference(name="parentExec", required=false)
    private Execution parent = null;
    @Reference(name="childs", required=false)
    private final List<Execution> childExecutions = new ArrayList<Execution>();
    private Exception exception;
    private ConcurrentHashMapWithDefaults<String, Object> variableValues = new ConcurrentHashMapWithDefaults();
    private ConcurrentHashMapWithDefaults<String, Element> partnerValues = new ConcurrentHashMapWithDefaults();

    public Node getCurrentTarget() {
        return this.currentTarget;
    }

    public synchronized void run() throws CoreException {
        this.log.fine("execution run begins for " + this.getName());
        this.setState(Execution.State.ACTIVE);
        while (this.getState() != Execution.State.ENDED && this.getState() != Execution.State.CANCELLED && this.getState() != Execution.State.SUSPENDED) {
            this.step();
        }
    }

    public void removeChildExecution(Execution execution) throws CoreException {
        if (execution != null) {
            try {
                Object obj = SCAHelper.getSCAHelper().getParent(this.getComponent()).getFcInterface("service");
                if (obj instanceof Scope) {
                    Scope scope = (Scope)obj;
                    Component exeComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)execution.getComponent().getFcInterface("service"), "service");
                    if (exeComp != null) {
                        SCAHelper.getSCAHelper().deleteComponent(exeComp);
                    }
                }
            }
            catch (NoSuchInterfaceException e) {
                throw new CoreException((Throwable)e);
            }
            catch (SCAException e) {
                throw new CoreException((Throwable)e);
            }
        }
    }

    public final boolean hasCurrentTarget() {
        return this.currentTarget != null;
    }

    public final void setInitialTarget(Node initialTarget) {
        this.setCurrentTarget(initialTarget);
    }

    private final void setCurrentTarget(Node currentTarget) {
        String oldTargetName = this.currentTarget != null ? this.currentTarget.getName() : "none";
        this.currentTarget = currentTarget;
        if (this.currentTarget == null) {
            return;
        }
        try {
            Node target = null;
            if (currentTarget instanceof ServiceReference) {
                ServiceReference sr = (ServiceReference)currentTarget;
                target = (Node)SCAHelper.getSCAHelper().getBoundInterface(sr);
            } else {
                target = currentTarget;
            }
            Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(SCAHelper.getSCAHelper().getParent(this.getComponent()), (Interface)target, "service");
            if (targetComp != null && !SCAHelper.getSCAHelper().isStarted(targetComp)) {
                SCAHelper.getSCAHelper().startComponent(targetComp);
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        String newTargetName = this.currentTarget != null ? this.currentTarget.getName() : "none";
        this.log.fine(String.format("current target = '%s' ; next target = '%s'", oldTargetName, newTargetName));
    }

    public void end() throws CoreException {
        this.setCurrentTarget(null);
    }

    public List<Execution> getChildExecutions() {
        return Collections.unmodifiableList(this.childExecutions);
    }

    public Execution getParentExecution() {
        return this.parent;
    }

    public Execution.State getState() {
        return this.currentState.get();
    }

    public void setStateRecursively(Execution.State state) {
        this.setState(state);
        if (this.getParentExecution() != null) {
            this.getParentExecution().setStateRecursively(state);
        }
    }

    public void setState(Execution.State state) {
        this.currentState.set(state);
        this.log.fine("Execution " + this.getName() + " is now in state " + this.getState());
    }

    public void addExecution(Execution childExecution) throws CoreException {
        try {
            ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
            listOfBindings.add(new Binding("childs_" + String.valueOf(this.childExecutions.size()), (Interface)childExecution.getComponent().getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(this.getComponent(), listOfBindings);
            listOfBindings = new ArrayList();
            listOfBindings.add(new Binding("parentExec", (Interface)this.getComponent().getFcInterface("service")));
            SCAHelper.getSCAHelper().addBindings(childExecution.getComponent(), listOfBindings);
            try {
                ExecutionImpl childExecutionImpl = (ExecutionImpl)((Object)((SCAContentController)childExecution.getComponent().getFcInterface("/sca-content-controller")).getFcContent());
            }
            catch (ContentInstantiationException cie) {
                throw new CoreException((Throwable)cie);
            }
            childExecutionImpl.variableValues = this.variableValues;
            childExecutionImpl.partnerValues = this.partnerValues;
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public void removeChildExecutions() throws CoreException {
        Execution child = null;
        while (this.childExecutions != null && this.childExecutions.size() > 0) {
            child = this.childExecutions.iterator().next();
            this.log.fine("remove execution: " + child.getName());
            this.removeChildExecution(child);
        }
    }

    public void setParentExecution(Execution parent) {
        assert (parent != null);
        this.parent = parent;
        this.variableValues = new ConcurrentHashMapWithDefaults(((ExecutionImpl)parent).variableValues);
        this.partnerValues = new ConcurrentHashMapWithDefaults(((ExecutionImpl)parent).partnerValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void step() throws CoreException {
        if (this.getState() == Execution.State.ENDED) {
            return;
        }
        Node nextTarget = null;
        if (this.hasCurrentTarget()) {
            try {
                nextTarget = this.currentTarget.execute((Execution)this);
            }
            catch (CoreException e) {
                Scope faultScope = this.findFaultScope(e);
                if (faultScope == null || faultScope.getException() != null) {
                    this.log.fine("fault not catched: " + ((Object)((Object)e)).getClass().getName());
                    this.setException(e);
                    this.setState(Execution.State.ENDED);
                    throw e;
                }
                this.log.fine("fault catched by scope: " + faultScope.getName());
                faultScope.setException((Exception)((Object)e));
                try {
                    nextTarget = (Node)faultScope.getComponent().getFcInterface("service");
                }
                catch (NoSuchInterfaceException e1) {
                    throw new CoreException((Throwable)e1);
                }
            }
            this.setCurrentTarget(nextTarget);
        }
        if (!this.hasCurrentTarget()) {
            if (this.getParentExecution() != null) {
                Execution execution = this.getParentExecution();
                synchronized (execution) {
                    this.getParentExecution().removeChildExecution((Execution)this);
                }
            }
            this.setState(Execution.State.ENDED);
        }
    }

    public void runStepByStep() throws CoreException {
        this.stepByStep = true;
        this.setState(Execution.State.ACTIVE);
    }

    public synchronized void signal() throws CoreException {
        this.step();
    }

    public boolean isStepByStep() {
        return this.stepByStep;
    }

    public void setStepByStep(boolean stepByStep) {
        this.stepByStep = stepByStep;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Lifecycle(step=Step.DESTROY)
    public void destroySCAComponent() throws SCAException {
        this.log.fine("Fractal execution destroyed: " + this.getName());
        this.setState(Execution.State.CANCELLED);
    }

    public String toString() {
        String res = super.toString();
        if (this.getName() != null) {
            res = this.getName();
        }
        return res;
    }

    private static final void doGetSuspendedExecutions(Execution execution, Map<String, Execution> suspendedExecutions) {
        if (execution.getState() == Execution.State.SUSPENDED) {
            suspendedExecutions.put(execution.getName(), execution);
        }
        for (Execution childExecution : execution.getChildExecutions()) {
            ExecutionImpl.doGetSuspendedExecutions(childExecution, suspendedExecutions);
        }
    }

    public Map<String, Execution> getSuspendedExecutions() throws CoreException {
        HashMap<String, Execution> result = new HashMap<String, Execution>();
        ExecutionImpl.doGetSuspendedExecutions(this, result);
        return result;
    }

    private final void setException(CoreException exception) {
        this.exception = exception;
    }

    public final Exception getException() {
        return this.exception;
    }

    public final Object getVariableValue(String name) {
        return this.variableValues.getValueOrDefault((Object)name);
    }

    public Element getPartnerValue(String name) {
        return (Element)this.partnerValues.getValueOrDefault((Object)name);
    }

    public final void putVariableValue(String name, Object value) {
        this.variableValues.put((Object)name, value);
    }

    public void putPartnerValue(String name, Element value) {
        this.partnerValues.put((Object)name, (Object)value);
    }

    public final void assignVariableValue(String name, Object value) {
        Object map = this.variableValues;
        while (true) {
            assert (map != null);
            if (map.containsKey(name)) {
                map.put(name, value);
                return;
            }
            assert (map instanceof ConcurrentHashMapWithDefaults);
            map = map.getDefaults();
        }
    }

    public void assignPartnerValue(String name, Element value) {
        Object map = this.partnerValues;
        while (true) {
            assert (map != null);
            if (map.containsKey(name)) {
                map.put(name, value);
                return;
            }
            assert (map instanceof ConcurrentHashMapWithDefaults);
            map = map.getDefaults();
        }
    }

    public final void enterScope(Scope scope) {
        this.log.finest("---------------------------------ENTER SCOPE " + scope.getName());
        this.variableValues = new ConcurrentHashMapWithDefaults(this.variableValues);
        this.partnerValues = new ConcurrentHashMapWithDefaults(this.clone((Map<String, Element>)this.partnerValues));
        for (Variable var : scope.getVariables().values()) {
            var.initialize((Execution)this);
        }
        for (Partner partner : scope.getPartners().values()) {
            this.log.finest("---------------------------------INIT partner " + partner.getName());
            partner.initialize((Execution)this);
        }
    }

    private ConcurrentHashMapWithDefaults<String, Element> clone(Map<String, Element> partnerValues) {
        ConcurrentHashMapWithDefaults defaults = new ConcurrentHashMapWithDefaults(partnerValues);
        ConcurrentHashMapWithDefaults res = new ConcurrentHashMapWithDefaults((Map)defaults);
        for (Map.Entry<String, Element> entry : partnerValues.entrySet()) {
            String k = entry.getKey();
            Element v = (Element)entry.getValue().clone();
            res.put((Object)k, (Object)v);
        }
        return res;
    }

    public final void leaveScope() {
        this.log.finest("Execution " + this.getName() + " is leaving the scope " + this.getCurrentScope().getName());
        this.variableValues = (ConcurrentHashMapWithDefaults)this.variableValues.getDefaults();
        this.partnerValues = (ConcurrentHashMapWithDefaults)this.partnerValues.getDefaults();
    }

    private final Scope findFaultScope(CoreException e) throws CoreException {
        Scope faultScope = null;
        Exception exTest = null;
        Scope current = this.getCurrentScope();
        while (current != null) {
            exTest = current.getException();
            if (exTest == null) {
                for (Map.Entry entry : current.getExceptions().entrySet()) {
                    if (((Scope)entry.getValue()).getException() != null || ((Fault)entry.getKey()).getFaultHandler() == null || !((Fault)entry.getKey()).getFaultHandler().match((Execution)this, (Fault)entry.getKey(), e, (Scope)entry.getValue())) continue;
                    faultScope = (Scope)entry.getValue();
                    if (((Fault)entry.getKey()).getVariable() != null) {
                        e.setFaultVariableName(((Fault)entry.getKey()).getVariable().getName());
                    }
                    return faultScope;
                }
            }
            exTest = null;
            current = current.getParentScope();
        }
        return null;
    }

    public final Scope getCurrentScope() {
        try {
            Node currentTarget = (Node)this.getCurrentTarget().getComponent().getFcInterface("service");
            if (currentTarget instanceof Scope) {
                return (Scope)currentTarget;
            }
            return currentTarget.getScope();
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
    }
}

