/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.types.Step;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Node.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class NodeImpl
extends SCAComponentImpl
implements Node {
    private Logger log = Logger.getLogger(NodeImpl.class.getSimpleName());
    @Reference(name="childNodes", required=false)
    protected List<Node> childNodes = Collections.synchronizedList(new ArrayList());
    @Reference(name="incomingNodes", required=false)
    protected List<Node> incomingNodes = Collections.synchronizedList(new ArrayList());
    @Reference(name="outgoingNodes", required=false)
    protected List<Node> outgoingNodes = Collections.synchronizedList(new ArrayList());
    @Reference(name="behaviour", required=false)
    protected Behaviour behaviour;
    @Reference(name="parentNode", required=false)
    protected Node parentNode;

    @Lifecycle(step=Step.STOP)
    public void stopSCAComponent() throws SCAException {
        this.log.fine("node " + this.getName() + " is stopping... ");
        if (this.childNodes != null && this.childNodes.size() > 0) {
            Component parentComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            for (Node child : this.getChildNodes()) {
                this.log.fine("stop child node: " + this.getName());
                Component nodeComp = SCAHelper.getSCAHelper().getComponentByInterface(parentComp, (ServiceReference)child, "service");
                if (nodeComp == null || !SCAHelper.getSCAHelper().isStarted(nodeComp)) continue;
                SCAHelper.getSCAHelper().stopComponent(nodeComp);
            }
        }
        this.log.fine("node stopped: " + this.getName());
    }

    public void setActivity(Behaviour behaviour) {
        this.behaviour = behaviour;
    }

    public Behaviour getActivity() {
        return this.behaviour;
    }

    public final Node execute(Execution execution) throws CoreException {
        try {
            if (this.behaviour != null) {
                Component activityComp = null;
                if (this.behaviour instanceof ServiceReference) {
                    activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getScope().getComponent(), (ServiceReference)this.behaviour, "service");
                } else if (this.getScope() != null) {
                    activityComp = SCAHelper.getSCAHelper().getComponentByInterface(this.getScope().getComponent(), (Interface)this.behaviour, "service");
                }
                if (activityComp != null && !SCAHelper.getSCAHelper().isStarted(activityComp)) {
                    SCAHelper.getSCAHelper().startComponent(activityComp);
                }
                Node node = this.behaviour.execute(execution);
                return node;
            }
        }
        catch (SCAException e1) {
            throw new CoreException((Throwable)e1);
        }
        return null;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public List<Node> getChildNodes() {
        return new ArrayList<Node>(this.childNodes);
    }

    public Behaviour getBehaviour() {
        if (this.behaviour instanceof Interface) {
            return this.behaviour;
        }
        if (this.behaviour != null) {
            ServiceReference sr = (ServiceReference)this.behaviour;
            ServiceReferenceImpl cri = (ServiceReferenceImpl)sr;
            Object service = cri._getDelegate();
            ComponentInterface ci = (ComponentInterface)service;
            Interceptor intercep = (Interceptor)ci.getFcItfImpl();
            Behaviour itf = (Behaviour)intercep.getFcItfDelegate();
            return itf;
        }
        return null;
    }

    public String toString() {
        String res = "";
        res = "node " + this.getName();
        return res;
    }

    public List<Node> getIncomingNodes() {
        return this.incomingNodes;
    }

    public List<Node> getOutgoingNodes() {
        return this.outgoingNodes;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public Logger getLogger() {
        return this.log;
    }

    public Scope getScope() {
        Component scopeComponent;
        Scope res;
        block4: {
            res = null;
            scopeComponent = SCAHelper.getSCAHelper().getParent(this.getComponent());
            if (scopeComponent.getFcInterface("service") instanceof Scope) break block4;
            return null;
        }
        try {
            res = (Scope)scopeComponent.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public Process getProcess() {
        Scope scope = this.getScope();
        while (true) {
            assert (scope != null);
            if (scope instanceof Process) break;
            scope = scope.getScope();
        }
        return (Process)scope;
    }
}

