/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Assigner;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.osoa.sca.annotations.Property;

@org.oasisopen.sca.annotation.Scope(value="COMPOSITE")
@Service(value={Process.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ProcessImpl
extends ScopeImpl
implements Process {
    private Logger log = Logger.getLogger(ProcessImpl.class.getSimpleName());
    @Property(name="keys", required=true)
    private List<ProcessKey> keys;
    @Property(name="externalContexts", required=false)
    private Map<Partner, Map<String, ExternalContext>> externalContexts = Collections.synchronizedMap(new HashMap());
    private Assigner assigner = null;
    private boolean isUnstable = false;
    private AtomicReference<Execution> execution = new AtomicReference();
    private String executionName;

    public Engine getEngine() throws CoreException {
        Engine res = null;
        try {
            Component engineComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
            res = (Engine)engineComp.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    @Override
    public Process getProcess() throws CoreException {
        return this;
    }

    public Map<Partner, Map<String, ExternalContext>> getExternalContexts() {
        return this.externalContexts;
    }

    public ExternalContext getExternalContext(Partner serviceendpoint, String operation) {
        Map<String, ExternalContext> map = this.externalContexts.get(serviceendpoint);
        if (map != null) {
            return map.get(operation);
        }
        return null;
    }

    @Override
    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    @Override
    public void end(boolean clean) throws CoreException {
        this.log.fine("PROCESS ENDED : " + this.getName());
        for (Map<String, ExternalContext> mapOperationContext : this.externalContexts.values()) {
            for (ExternalContext externalContext : mapOperationContext.values()) {
                if (externalContext == null || externalContext.getTerminationHandler() == null) continue;
                externalContext.getTerminationHandler().end((Scope)this);
            }
        }
        this.getBehaviour().reset();
        super.end(clean);
    }

    public List<ProcessKey> getProcessKeys() {
        return this.keys;
    }

    public void setProcessKeys(List<ProcessKey> keys) {
        this.keys = keys;
    }

    public Assigner getAssigner() {
        return this.assigner;
    }

    public void setAssigner(Assigner assigner) {
        this.assigner = assigner;
    }

    public void addExternalContext(Partner partner, String operation, ExternalContext context) {
        if (partner == null) {
            return;
        }
        Map<String, Object> map = this.externalContexts.get(partner);
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
        }
        map.put(operation, context);
        this.externalContexts.put(partner, map);
        this.log.fine("add external context ... " + this.externalContexts);
    }

    public void clearExternalContexts() {
        this.externalContexts.clear();
    }

    public Behaviour findBehaviour(String activityName) {
        Behaviour behaviour = null;
        try {
            String nodeName = "node_supporting_" + activityName;
            Node n = this.getNodeByName(nodeName);
            if (n != null) {
                Component c = (Component)SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), nodeName).get(0);
                SCAHelper.getSCAHelper().startComponent(c);
                Component cb = (Component)SCAHelper.getSCAHelper().getComponentsByName(this.getComponent(), activityName).get(0);
                SCAHelper.getSCAHelper().startComponent(cb);
                return n.getBehaviour();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (SCAException e) {
            e.printStackTrace();
        }
        return behaviour;
    }

    public final boolean isUnstable() {
        return this.isUnstable;
    }

    public void setUnstable(boolean unstable) {
        this.isUnstable = unstable;
    }

    public boolean hasExecution() {
        return this.execution.get() != null;
    }

    public Execution getExecution() {
        assert (this.hasExecution());
        return this.execution.get();
    }

    public void setExecution(Execution execution) {
        this.execution.set(execution);
    }

    public static final ExternalContext getFirstExternalContext(Map<Partner, Map<String, ExternalContext>> contexts) {
        Map<String, ExternalContext> map = null;
        if (contexts.size() > 0) {
            map = contexts.values().iterator().next();
            if (map.values().size() > 0) {
                return map.values().iterator().next();
            }
            return null;
        }
        return null;
    }

    public String getProcessExecutionName() {
        return this.executionName;
    }

    public void setProcessExecutionName(String name) {
        this.executionName = name;
    }
}

