/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.pattern;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.Binding;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.ScopeImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ExclusiveBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.FlowBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.IfBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.LoopBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ScopeBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.SequenceBehaviourImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

public class CreationPatternFactory {
    private static CreationPatternFactory instance;

    private CreationPatternFactory() {
    }

    public static CreationPatternFactory getInstance() {
        if (instance == null) {
            instance = new CreationPatternFactory();
        }
        return instance;
    }

    public Node createSequencePattern(String name, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            parentNode = scope.createNode(name, SequenceBehaviourImpl.class, null);
            if (childNodes != null) {
                Iterator<Node> it = childNodes.iterator();
                Node source = null;
                Node target = null;
                Node lastNode = null;
                Component sourceComp = null;
                Component targetComp = null;
                Component lastComp = null;
                while (it.hasNext()) {
                    source = it.next();
                    sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)source, "service");
                    String sourceName = SCAHelper.getSCAHelper().getName(sourceComp);
                    if (lastNode != null) {
                        scope.linkedBrotherNodes(lastNode, source);
                    }
                    if (it.hasNext()) {
                        target = it.next();
                        targetComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)target, "service");
                        scope.linkedBrotherNodes(source, target);
                        lastNode = target;
                        lastComp = targetComp;
                        continue;
                    }
                    lastNode = null;
                    lastComp = null;
                }
                if (childNodes != null) {
                    for (Node children : childNodes) {
                        scope.linkedChildNodeToParent(parentNode, children);
                    }
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parentNode;
    }

    public Process createProcessPattern(String name, Engine engine) {
        return (Process)this.doCreateScopePattern(name, ProcessImpl.class, engine.getComponent());
    }

    public Scope createScopePattern(String name, Scope parentScope) throws CoreException {
        assert (parentScope != null);
        return (Scope)this.doCreateScopePattern(name, ScopeImpl.class, parentScope.getComponent());
    }

    private Node doCreateScopePattern(String name, Class<?> scopeClass, Component parentComponent) throws CoreException {
        Scope underscope = null;
        try {
            Component underscopeComp = SCAHelper.getSCAHelper().createNewComponent(scopeClass.getName(), null);
            SCAHelper.getSCAHelper().addComponent(underscopeComp, parentComponent, null);
            SCAContentController scacc = (SCAContentController)underscopeComp.getFcInterface("/sca-content-controller");
            try {
                underscope = (Scope)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            underscope.setName(name);
            SCAHelper.getSCAHelper().startComponent(underscopeComp);
            underscope = (Node)underscopeComp.getFcInterface("service");
            Component fractalActivity = SCAHelper.getSCAHelper().createNewComponent(ScopeBehaviourImpl.class.getName(), null);
            SCAHelper.getSCAHelper().changeName(fractalActivity, String.valueOf(ScopeBehaviourImpl.class.getSimpleName()) + "4" + SCAHelper.getSCAHelper().getName(underscopeComp));
            SCAHelper.getSCAHelper().addComponent(fractalActivity, parentComponent, null);
            SCAHelper.getSCAHelper().startComponent(fractalActivity);
            Behaviour behaviour = (Behaviour)fractalActivity.getFcInterface("service");
            CreationPatternFactory.linkNodeAndFunctionalBehaviour(parentComponent, (Node)underscope, behaviour);
            underscope.setActivity(behaviour);
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return underscope;
    }

    public Node createIfPattern(String name, List<Expression> expressions, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        if (expressions == null || expressions.size() == 0 || childNodes.size() == expressions.size() && childNodes.size() == expressions.size() + 1) {
            throw new CoreException("Invalid if pattern");
        }
        HashMap<String, List<Expression>> context = new HashMap<String, List<Expression>>();
        context.put("conditions", expressions);
        parentNode = scope.createNode(name, IfBehaviourImpl.class, context);
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent(parentNode, children);
            }
        }
        return parentNode;
    }

    public Node createLoopPattern(String name, Expression condition, boolean applyConditionAtBegin, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        try {
            if (scope == null) {
                throw new CoreException("scope cannot be null");
            }
            if (condition == null) {
                throw new CoreException("condition cannot be null");
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("condition", condition);
            context.put("applyConditionAtBegin", applyConditionAtBegin);
            parentNode = scope.createNode(name, LoopBehaviourImpl.class, context);
            if (childNodes != null) {
                Iterator<Node> it = childNodes.iterator();
                Node source = null;
                Node target = null;
                Node lastNode = null;
                Component sourceComp = null;
                Component targetComp = null;
                Component lastComp = null;
                String transitionName = "t";
                while (it.hasNext()) {
                    source = it.next();
                    sourceComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)source, "service");
                    if (lastNode != null) {
                        scope.linkedBrotherNodes(lastNode, source);
                    }
                    if (it.hasNext()) {
                        target = it.next();
                        targetComp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)target, "service");
                        scope.linkedBrotherNodes(source, target);
                        lastNode = target;
                        lastComp = targetComp;
                        continue;
                    }
                    lastNode = null;
                    lastComp = null;
                }
                if (childNodes != null) {
                    for (Node children : childNodes) {
                        scope.linkedChildNodeToParent(parentNode, children);
                    }
                }
            }
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        return parentNode;
    }

    public Node createFlowPattern(String name, List<Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        parentNode = scope.createNode(name, FlowBehaviourImpl.class, null);
        if (childNodes != null) {
            for (Node children : childNodes) {
                scope.linkedChildNodeToParent2(parentNode, children);
            }
        }
        return parentNode;
    }

    public Node createExclusivePattern(String name, Map<Node, Node> childNodes, Scope scope) throws CoreException {
        Node parentNode = null;
        if (scope == null) {
            throw new CoreException("scope cannot be null");
        }
        HashMap<String, Set<Node>> context = new HashMap<String, Set<Node>>();
        if (childNodes != null) {
            context.put("triggeringNodes", childNodes.keySet());
        }
        parentNode = scope.createNode(name, ExclusiveBehaviourImpl.class, context);
        if (childNodes != null) {
            HashMap<WaitBehaviour, Node> waitingNodes = new HashMap<WaitBehaviour, Node>();
            for (Node child : childNodes.keySet()) {
                try {
                    Component comp = SCAHelper.getSCAHelper().getComponentByInterface(scope.getComponent(), (Interface)child, "service");
                    SCAHelper.getSCAHelper().startComponent(comp);
                }
                catch (SCAException e) {
                    throw new CoreException((Throwable)e);
                }
                if (!(child.getBehaviour() instanceof WaitBehaviour)) continue;
                waitingNodes.put((WaitBehaviour)child.getBehaviour(), child);
            }
            for (Node child : childNodes.keySet()) {
                scope.linkedChildNodeToParent(parentNode, child);
                Node follower = childNodes.get(child);
                if (follower == null) continue;
                try {
                    scope.linkedChildNodeToParent(parentNode, follower);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return parentNode;
    }

    private static void linkNodeAndFunctionalBehaviour(Component parentComponent, Node targetNode, Behaviour behaviour) throws CoreException {
        try {
            if (behaviour != null && targetNode != null) {
                Component targetComp = SCAHelper.getSCAHelper().getComponentByInterface(parentComponent, (Interface)targetNode, "service");
                Component activityComp = SCAHelper.getSCAHelper().getComponentByInterface(parentComponent, (Interface)behaviour, "service");
                if (targetComp == null || activityComp == null) {
                    throw new CoreException("Impossible to link node to a transition");
                }
                ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
                listOfBindings.add(new Binding("behaviour", (Interface)activityComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(targetComp, listOfBindings);
                listOfBindings = new ArrayList();
                listOfBindings.add(new Binding("node", (Interface)targetComp.getFcInterface("service")));
                SCAHelper.getSCAHelper().addBindings(activityComp, listOfBindings);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }
}

