/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.env;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalEnvironment;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

@Scope(value="COMPOSITE")
@Service(value={ExternalEnvironment.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ExternalEnvironmentImpl
extends SCAComponentImpl
implements ExternalEnvironment {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_EXTERNAL_ENVIRONMENT_NAME = "ExternalEnvironment";
    private Logger log = Logger.getLogger(ExternalEnvironmentImpl.class.getName());
    private final List<Component> receivers = new ArrayList<Component>();
    private final List<Component> senders = new ArrayList<Component>();
    @Reference(name="engine")
    private Engine engine;
    private String host;
    private String port;

    public Receiver addReceiver(Class<? extends Receiver> receiverClass) throws CoreException {
        Receiver receiver = null;
        this.checkEngine();
        if (this.engine == null) {
            throw new CoreException("You must create the engine before create an receiver!!!");
        }
        try {
            Component fractalReceiver = SCAHelper.getSCAHelper().createNewComponent(receiverClass.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalReceiver, this.getComponent(), null);
            this.receivers.add(fractalReceiver);
            SCAContentController scacc = (SCAContentController)fractalReceiver.getFcInterface("/sca-content-controller");
            try {
                receiver = (Receiver)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
                receiver.setLog(this.log);
            }
            SCAHelper.getSCAHelper().startComponent(fractalReceiver);
            SCAHelper.getSCAHelper().changeName(fractalReceiver, String.valueOf(receiverClass.getSimpleName()) + "_" + this.receivers.size());
            receiver = (Receiver)fractalReceiver.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("receiver created and started");
        return receiver;
    }

    public List<Receiver> getReceivers() throws CoreException {
        ArrayList<Receiver> res = new ArrayList<Receiver>();
        for (Component comp : this.receivers) {
            try {
                res.add((Receiver)comp.getFcInterface("service"));
            }
            catch (NoSuchInterfaceException e) {
                throw new CoreException((Throwable)e);
            }
        }
        return res;
    }

    public Sender addSender(Class<? extends Sender> senderClass) throws CoreException {
        Sender sender = null;
        this.checkEngine();
        if (this.engine == null) {
            throw new CoreException("You must create the engine before create an sender!!!");
        }
        try {
            Component fractalSender = SCAHelper.getSCAHelper().createNewComponent(senderClass.getName(), null);
            SCAHelper.getSCAHelper().addComponent(fractalSender, this.getComponent(), null);
            this.senders.add(fractalSender);
            SCAContentController scacc = (SCAContentController)fractalSender.getFcInterface("/sca-content-controller");
            try {
                sender = (Sender)scacc.getFcContent();
            }
            catch (ContentInstantiationException e) {
                throw new CoreException((Throwable)e);
            }
            if (!this.log.getName().equals(ExternalEnvironmentImpl.class.getName())) {
                sender.setLog(this.log);
            }
            SCAHelper.getSCAHelper().startComponent(fractalSender);
            SCAHelper.getSCAHelper().changeName(fractalSender, String.valueOf(senderClass.getSimpleName()) + "_" + this.senders.size());
            sender = (Sender)fractalSender.getFcInterface("service");
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
        this.log.finest("sender created and started");
        return sender;
    }

    public List<Sender> getSenders() throws CoreException {
        ArrayList<Sender> res = new ArrayList<Sender>();
        for (Component comp : this.senders) {
            try {
                res.add((Sender)comp.getFcInterface("service"));
            }
            catch (NoSuchInterfaceException e) {
                throw new CoreException((Throwable)e);
            }
        }
        return res;
    }

    private void checkEngine() throws CoreException {
        try {
            if (this.engine == null) {
                Component coreComp = SCAHelper.getSCAHelper().getParent(this.getComponent());
                Core core = (Core)coreComp.getFcInterface("service");
                this.engine = core.getEngine();
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new CoreException((Throwable)e);
        }
        catch (SCAException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

