/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.tools;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public final class InstanceOfUtil {

	public static <C> boolean isClassExtendOfClass2found(Class<?> c, Class<? extends C> class2found) {
		boolean res = false;
		try {
			if(c != null) {
				if(c.getName().equals(class2found.getName())) {
					res = true;
				} else if(c.getInterfaces() != null) {
					for(Class<?> subc : c.getInterfaces()) {
						res = isClassExtendOfClass2found(subc, class2found);
						if(res == true) {
							break;
						}
					}
				}
			}
		} catch(ClassCastException e) {

		}
		return res;
	}
	
}
