/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class FlowPatternTest
extends AbstractCoreTest {
    @Test(timeout=10000L)
    public void testForkWithoutChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        Node initial = CreationPatternFactory.getInstance().createFlowPattern("fork", null, (Scope)process);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().runStepByStep(process);
        execution.signal();
        Assert.assertEquals((String)"ForkProcess", (String)process.getExecution().getCurrentTarget().getName());
        execution.signal();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getExecution().getCurrentTarget().getName());
        execution.signal();
        execution.signal();
        execution.signal();
        this.checkExecutionEndedProperly(execution);
    }

    @Test
    public void testForkWithOneChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createFlowPattern("fork", childNodes, (Scope)process);
        process.setInitialNode(initial);
        Execution main = core.getEngine().runStepByStep(process);
        main.signal();
        Assert.assertEquals((String)"ForkProcess", (String)main.getCurrentTarget().getName());
        main.signal();
        main.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)main.getCurrentTarget().getName());
        main.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)main.getCurrentTarget().getName());
        Assert.assertEquals((int)1, (int)main.getChildExecutions().size());
        Execution childExecution1 = (Execution)main.getChildExecutions().get(0);
        Assert.assertNotNull((Object)childExecution1);
        Assert.assertEquals((String)"node_supporting_first", (String)childExecution1.getCurrentTarget().getName());
        childExecution1.signal();
        this.checkExecutionEndedProperly(childExecution1);
        main.signal();
        main.signal();
        main.signal();
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testForkWithTwoChildAndAroundNodePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node fork = CreationPatternFactory.getInstance().createFlowPattern("fork", childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, fork);
        process.linkedBrotherNodes(fork, end);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }

    @Test(timeout=10000L)
    public void testForkWithUnderForkAndWithTwoChildAndAroundNodePatternStepByStep() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodesFirst = new ArrayList<Node>();
        childNodesFirst.add(process.createNode("childfirst_1", EmptyBehaviourImpl.class, null));
        childNodesFirst.add(process.createNode("childfirst_2", EmptyBehaviourImpl.class, null));
        Node childfork1 = CreationPatternFactory.getInstance().createFlowPattern("firstfork", childNodesFirst, (Scope)process);
        ArrayList<Node> childNodesSecond = new ArrayList<Node>();
        childNodesSecond.add(process.createNode("childsecond_1", EmptyBehaviourImpl.class, null));
        childNodesSecond.add(process.createNode("childsecond_2", EmptyBehaviourImpl.class, null));
        Node childfork2 = CreationPatternFactory.getInstance().createFlowPattern("secondfork", childNodesSecond, (Scope)process);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(childfork1);
        childNodes.add(childfork2);
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node fork = CreationPatternFactory.getInstance().createFlowPattern("fork", childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, fork);
        process.linkedBrotherNodes(fork, end);
        process.setInitialNode(initial);
        Execution main = core.getEngine().runStepByStep(process);
        Assert.assertEquals((String)"ForkProcess", (String)main.getCurrentTarget().getName());
        main.signal();
        Assert.assertEquals((String)"ForkProcess", (String)main.getCurrentTarget().getName());
        main.signal();
        Assert.assertEquals((String)"node_supporting_start", (String)main.getCurrentTarget().getName());
        main.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)main.getCurrentTarget().getName());
        main.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)main.getCurrentTarget().getName());
        main.signal();
        Assert.assertEquals((int)2, (int)main.getChildExecutions().size());
        Execution firstForkExecution = (Execution)main.getChildExecutions().get(0);
        Execution secondForkExecution = (Execution)main.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_firstfork", (String)firstForkExecution.getCurrentTarget().getName());
        firstForkExecution.signal();
        Assert.assertEquals((String)"node_supporting_firstfork", (String)firstForkExecution.getCurrentTarget().getName());
        firstForkExecution.signal();
        Assert.assertEquals((int)2, (int)firstForkExecution.getChildExecutions().size());
        Execution childFirst1Execution = (Execution)firstForkExecution.getChildExecutions().get(0);
        Execution childFirst2Execution = (Execution)firstForkExecution.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_childfirst_1", (String)childFirst1Execution.getCurrentTarget().getName());
        childFirst1Execution.signal();
        this.checkExecutionEndedProperly(childFirst1Execution);
        Assert.assertEquals((String)"node_supporting_childfirst_2", (String)childFirst2Execution.getCurrentTarget().getName());
        childFirst2Execution.signal();
        this.checkExecutionEndedProperly(childFirst2Execution);
        firstForkExecution.signal();
        this.checkExecutionEndedProperly(firstForkExecution);
        Assert.assertEquals((String)"node_supporting_secondfork", (String)secondForkExecution.getCurrentTarget().getName());
        secondForkExecution.signal();
        Assert.assertEquals((String)"node_supporting_secondfork", (String)secondForkExecution.getCurrentTarget().getName());
        secondForkExecution.signal();
        Assert.assertEquals((int)2, (int)secondForkExecution.getChildExecutions().size());
        Execution childSecond1Execution = (Execution)secondForkExecution.getChildExecutions().get(0);
        Execution childSecond2Execution = (Execution)secondForkExecution.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_childsecond_1", (String)childSecond1Execution.getCurrentTarget().getName());
        childSecond1Execution.signal();
        this.checkExecutionEndedProperly(childSecond1Execution);
        Assert.assertEquals((String)"node_supporting_childsecond_2", (String)childSecond2Execution.getCurrentTarget().getName());
        childSecond2Execution.signal();
        this.checkExecutionEndedProperly(childSecond2Execution);
        secondForkExecution.signal();
        this.checkExecutionEndedProperly(secondForkExecution);
        main.signal();
        main.signal();
        main.signal();
        this.checkExecutionEndedProperly(main);
    }

    @Test(timeout=10000L)
    public void testForkWithUnderForkAndWithTwoChildAndAroundNodePatternRun() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = this.getCoreUnderTest();
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodesFirst = new ArrayList<Node>();
        childNodesFirst.add(process.createNode("childfirst_1", EmptyBehaviourImpl.class, null));
        childNodesFirst.add(process.createNode("childfirst_2", EmptyBehaviourImpl.class, null));
        Node childfork1 = CreationPatternFactory.getInstance().createFlowPattern("firstfork", childNodesFirst, (Scope)process);
        ArrayList<Node> childNodesSecond = new ArrayList<Node>();
        childNodesSecond.add(process.createNode("childsecond_1", EmptyBehaviourImpl.class, null));
        childNodesSecond.add(process.createNode("childsecond_2", EmptyBehaviourImpl.class, null));
        Node childfork2 = CreationPatternFactory.getInstance().createFlowPattern("secondfork", childNodesSecond, (Scope)process);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(childfork1);
        childNodes.add(childfork2);
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node fork = CreationPatternFactory.getInstance().createFlowPattern("fork", childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, fork);
        process.linkedBrotherNodes(fork, end);
        process.setInitialNode(initial);
        Execution execution = core.getEngine().run(process);
        this.checkExecutionEndedProperly(execution);
    }
}

