/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import java.util.List;

import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@org.oasisopen.sca.annotation.Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value = LoopBehaviour.class, names = "service")
public class LoopBehaviourImpl extends AbstractComplexBehaviourImpl implements LoopBehaviour {

    @Property(name = "condition", required = true)
    private Expression condition;

    @Property(name = "applyConditionAtBegin", required = true)
    private boolean applyConditionAtBegin = true;

    private final boolean whileExecution(Execution execution, boolean first) throws CoreException {
        Boolean cond = getNode().getScope().getExpressionEvaluator()
                .evaluateAsBoolean(execution, this.condition);
        assert cond != null;
        selectNextNodeToExecute(execution, null);
        if (cond) {
            final List<Node> childs = getNode().getChildNodes();
            if ((childs != null) && (childs.size() > 0)) {
                if (!first) {
                    for (Node childNode : childs) {
                        childNode.getBehaviour().reset();
                    }
                }
                selectNextNodeToExecute(execution, childs.get(0));
            }
        }
        return cond;
    }

    private final boolean repeatUntilExecution(Execution execution, boolean first)
            throws CoreException {

        boolean ok = true;
        selectNextNodeToExecute(execution, null);
        if (!first) {
            Boolean cond = getNode().getScope().getExpressionEvaluator()
                    .evaluateAsBoolean(execution, this.condition);
            if (cond == false) {
                ok = false;
            } else {
                final List<Node> childs = getNode().getChildNodes();
                for (Node childNode : childs) {
                    childNode.getBehaviour().reset();
                }
            }
        }

        if (ok) {
            final List<Node> childs = getNode().getChildNodes();
            if ((childs != null) && (!childs.isEmpty())) {
                selectNextNodeToExecute(execution, childs.get(0));
            }
        }
        return ok;
    }

    @Override
    protected State executeOnInactive(Execution execution) throws CoreException {
        if (this.applyConditionAtBegin == true) {
            this.whileExecution(execution, true);
        } else {
            this.repeatUntilExecution(execution, true);
        }
        return State.ACTIVITY_STARTED;
    }

    @Override
    protected State executeOnStarted(Execution execution) throws CoreException {
        boolean again = false;
        if (this.applyConditionAtBegin == true) {
            again = whileExecution(execution, false);
        } else {
            again = repeatUntilExecution(execution, false);
        }
        return again ? State.ACTIVITY_STARTED : State.ACTIVITY_ENDED;

    }
}
