/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.model;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.Model;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.AbstractCompiler;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.Compiler;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.AbstractProcessDefinitionRegistry;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessDefinitionRegistry;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=Model.class,names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ModelImpl extends SCAComponentImpl implements Model {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Logger log = Logger.getLogger(ModelImpl.class.getName());

	private Component compilerComponent;

	private Component registryComponent;


	public Core getCore() throws CoreException {
		Core res = null;
		try {
			final Component coreComp = SCAHelper.getSCAHelper().getParent(
					this.getComponent());
			res = (Core) coreComp.getFcInterface("service");
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (final SCAException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public Compiler createCompiler(final String name,
			final Class<? extends AbstractCompiler> compilerClass)
	throws CoreException {
		if (this.compilerComponent != null) {
			throw new CoreException("Error: Registry already exist!!!");
		}

		Compiler compiler = null;
		try {
			this.compilerComponent = SCAHelper.getSCAHelper()
			.createNewComponent(compilerClass.getName(), null);
			SCAHelper.getSCAHelper().addComponent(this.compilerComponent,
					getComponent(), null);


			compiler = (Compiler) (((SCAContentController)this.compilerComponent.getFcInterface("/sca-content-controller")).getFcContent());

			if (!this.log.getName().equals(ModelImpl.class.getName())) {
				compiler.setLog(this.log);
			}

			SCAHelper.getSCAHelper().startComponent(
					this.compilerComponent);
			SCAHelper.getSCAHelper().changeName(this.compilerComponent,
					name);

			compiler = (Compiler) this.compilerComponent
			.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		this.log.finest("compiler created and started");

		return compiler;
	}

	public Compiler getCompiler() throws CoreException {
		Compiler res = null;
		try {
			if (this.compilerComponent != null) {
				final Object obj = this.compilerComponent.getFcInterface("service");
				res = (Compiler) this.compilerComponent
				.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public ProcessDefinitionRegistry createRegistry(final String name,
			final Class<? extends AbstractProcessDefinitionRegistry> registryClass)
	throws CoreException {
		ProcessDefinitionRegistry registry = null;
		if (this.registryComponent != null) {
			throw new CoreException("Error: Registry already exist!!!");
		}

		try {
			this.registryComponent = SCAHelper.getSCAHelper()
			.createNewComponent(registryClass.getName(), null);
			SCAHelper.getSCAHelper().addComponent(this.registryComponent,
					getComponent(), null);


			//compiler = (Compiler) (((SCAContentController)this.compilerComponent.getFcInterface("/sca-content-controller")).getFcContent());
			registry = (ProcessDefinitionRegistry)(((SCAContentController)this.registryComponent.getFcInterface("/sca-content-controller")).getFcContent());
			//registry = (ProcessDefinitionRegistry) this.registryComponent.getFcInterface("/content");
			//			(registry).init(this.registryComponent);
			if (!this.log.getName().equals(ModelImpl.class.getName())) {
				registry.setLog(this.log);
			}

			SCAHelper.getSCAHelper().startComponent(
					this.registryComponent);
			SCAHelper.getSCAHelper().changeName(this.registryComponent,
					name);

			registry = (ProcessDefinitionRegistry) this.registryComponent
			.getFcInterface("service");

		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		} catch (ContentInstantiationException e) {
			throw new CoreException(e);
		} catch (SCAException e) {
			throw new CoreException(e);
		}
		this.log.finest("registry created and started");

		return registry;
	}

	public ProcessDefinitionRegistry getRegistry() throws CoreException {
		ProcessDefinitionRegistry res = null;
		try {
			if (this.registryComponent != null) {
				final Object obj = this.registryComponent.getFcInterface("service");
				res = (ProcessDefinitionRegistry) this.registryComponent
				.getFcInterface("service");
			}
		} catch (final NoSuchInterfaceException e) {
			throw new CoreException(e);
		}
		return res;
	}

	public void setLog(final Logger logger) {
		this.log = logger;
	}

}
