/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.impl.engine;

import java.util.Collection;

import javax.lang.model.element.ExecutableElement;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;

/**
 * Message aimed at specifying to an execution its next {@link ExecutableElement}. 
 * @author Marc Jambert - EBM WebSourcing
 */
public final class ExecutionMessage {

	private final Execution execution;
	private final Collection<? extends Node> nextNodesToExecute;
	
	// TODO replace execution by node.
	
	public ExecutionMessage(Execution execution, 
			Collection<? extends Node> nextExecutableElements) {
	    assert execution != null;
		this.execution = execution;
		assert nextExecutableElements != null;
		this.nextNodesToExecute = nextExecutableElements;
	}
//	
//	public final Execution getExecution() {
//		return execution;
//	}
//	
	public final Collection<? extends Node> getNextNodesToExecute() {
		return nextNodesToExecute;
	}
}
