/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractComplexBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ExclusiveBehaviour;
import com.ebmwebsourcing.easyviper.core.impl.engine.ExecutionThread;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.FlowBehaviourImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={ExclusiveBehaviour.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyCompositeWithContent"})
public class ExclusiveBehaviourImpl
extends AbstractComplexBehaviourImpl
implements ExclusiveBehaviour {
    private static final SimpleUUIDGenerator uuidGenerator = new SimpleUUIDGenerator();
    @Property(name="triggeringNodes", required=false)
    private Set<Node> triggeringNodes;
    @Property(name="exclusiveNodeToExecute", required=false)
    private Node exclusiveNodeToExecute = null;
    private List<Thread> childExecutionThreads = new ArrayList<Thread>();
    private Execution mainExec = null;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Behaviour.State executeOnStarted(Execution execution) {
        if (this.triggeringNodes != null) {
            if (this.mainExec == null) {
                this.mainExec = execution;
            }
            List childNodes = this.getNode().getChildNodes();
            assert (childNodes != null);
            for (Node childNode : this.triggeringNodes) {
                ExecutionThread executionThread = FlowBehaviourImpl.startChildExecution(this.getNode().getProcess(), execution, childNode, uuidGenerator, this.log);
                System.err.println("------------- start exec " + executionThread + " on node " + childNode.getName());
                this.childExecutionThreads.add(executionThread);
            }
            Process process = this.getNode().getProcess();
            Engine engine = process.getEngine();
            if (!engine.getConfiguration().getSingleThreadedExecution()) {
                for (Thread thread : this.childExecutionThreads) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {
                        throw new UncheckedException((Throwable)e);
                    }
                }
            }
            if (this.triggeringNodes.size() > 0) {
                if (this.exclusiveNodeToExecute == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            throw new CoreException((Throwable)e);
                        }
                    }
                }
                if (this.exclusiveNodeToExecute != null) {
                    execution.setStateRecursively(Execution.State.ACTIVE);
                    this.selectNextNodeToExecute(execution, this.exclusiveNodeToExecute);
                }
            } else {
                this.selectNextNodeToExecute(execution, null);
            }
        } else {
            this.selectNextNodeToExecute(execution, null);
        }
        return Behaviour.State.ACTIVITY_ENDED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Node onChildBehaviourNotification(Execution childExecution, Node nextNode, Behaviour childBehaviour) throws CoreException {
        Object object;
        this.log.fine("Notification received from " + childBehaviour.getName());
        if (this.childExecutionThreads.size() == 1 && nextNode == null) {
            this.selectNextNodeToExecute(this.mainExec, null);
            this.exclusiveNodeToExecute = this.nextTarget;
            object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
        this.log.fine("next node " + nextNode);
        if (this.exclusiveNodeToExecute == null) {
            this.exclusiveNodeToExecute = nextNode;
            object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        } else {
            for (ExecutionThread childExec : Arrays.asList(this.childExecutionThreads.toArray(new ExecutionThread[this.childExecutionThreads.size()]))) {
                if (childExec.getExecution() != childExecution) continue;
                childExec.getExecution().setState(Execution.State.CANCELLED);
                this.childExecutionThreads.remove(childExec);
            }
            return null;
        }
        childExecution.getCurrentTarget().getBehaviour().setCurrentExecution(this.mainExec);
        childExecution.setState(Execution.State.CANCELLED);
        this.childExecutionThreads.remove(childExecution);
        return this.getNode();
    }

    public void reset() {
        super.reset();
        this.exclusiveNodeToExecute = null;
        this.childExecutionThreads = new ArrayList<Thread>();
        this.mainExec = null;
    }
}

