/****************************************************************************
 *
 * Copyright (c) 2009-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.BreakpointBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.api.DebugBehaviour;
import com.ebmwebsourcing.easyviper.core.extended.behaviours._package.debug.util.DebugUtil;
import com.ebmwebsourcing.easyviper.core.service.extended.behaviour.api.AbstractExtendedBehaviourImpl;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=BreakpointBehaviour.class,names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class BreakpointBehaviourImpl extends AbstractExtendedBehaviourImpl implements
BreakpointBehaviour {

	private Logger log = Logger.getLogger(BreakpointBehaviourImpl.class
			.getName());

	public BreakpointBehaviourImpl() {

	}


	@Override
	protected void doExecute(Execution execution) {
		this.log.finest("start breakpoint behaviour on node: "
				+ getNode().getName());

		DebugBehaviour debug = DebugUtil.findDebugBehaviour(this.getNode().getProcess());
		if (debug != null) {
			this.log.finest("is debug mode? "
					+ debug.isActivate());
		} else {
			this.log.finest("is debug mode? false - no debug behaviour found");
		}
		if (debug != null && debug.isActivate()) {
			execution.setState(
					Execution.State.SUSPENDED);
			this.log.finest("breakpoint behaviour: suspend the execution "
					+ execution.getName() + " => "
					+ execution.getState());
		}
	}



}