/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.extended.service.autotrash.impl;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.thread.service.AbstractServiceImpl;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.extended.service.autotrash.api.AutoTrashProcessService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class AutoTrashProcessServiceImpl
extends AbstractServiceImpl
implements AutoTrashProcessService {
    private static final int NUMBER_OF_CLEAN_BEFORE_DELETING = 2;
    private Logger log = Logger.getLogger(AutoTrashProcessServiceImpl.class.getName());
    private final List<TrashProcessInstance> list = Collections.synchronizedList(new ArrayList());

    public AutoTrashProcessServiceImpl(Engine engine) {
        super(engine);
    }

    public void run() {
        try {
            this.tryToEndAllProcessIntances();
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.severe("Error in auto trash service: " + e.getMessage());
        }
    }

    @Override
    public void tryToEndAllProcessIntances() {
        ArrayList<TrashProcessInstance> process = new ArrayList<TrashProcessInstance>();
        process.addAll(this.list);
        this.list.clear();
        for (TrashProcessInstance p : process) {
            try {
                if (p.getNumberOfClean() == 2) {
                    this.log.warning("try to delete instance: " + p.getProcessInstance().getName());
                    SCAHelper.getSCAHelper().stopComponent(p.getProcessInstance().getComponent());
                    SCAHelper.getSCAHelper().deleteComponent(p.getProcessInstance().getComponent());
                    continue;
                }
                this.log.warning("try to clean instance: " + p.getProcessInstance().getName());
                p.getProcessInstance().end(true);
                List keys = p.getProcessInstance().getProcessKeys();
                for (ProcessKey key : keys) {
                    ArrayList<Process> listP = (ArrayList<Process>)this.getEngine().getProcessInstanceRegistry().getMap().get(key);
                    if (listP == null) {
                        listP = new ArrayList<Process>();
                    }
                    listP.add(p.getProcessInstance());
                    this.getEngine().getProcessInstanceRegistry().getMap().put(key, listP);
                }
            }
            catch (CoreException e) {
                p.setNumberOfClean(p.getNumberOfClean() + 1);
                this.log.warning("impossible to ended this instance: " + p.getProcessInstance().getName());
                this.list.add(p);
            }
            catch (SCAException e) {
                p.setNumberOfClean(p.getNumberOfClean() + 1);
                this.log.warning("impossible to ended this instance: " + p.getProcessInstance().getName());
                this.list.add(p);
            }
        }
    }

    @Override
    public void addUninstableProcessInstance(Process p) {
        if (p.getState().equals((Object)Process.State.PROCESS_UNSTABLE)) {
            this.list.add(new TrashProcessInstance(p));
        }
    }

    private class TrashProcessInstance {
        private int numberOfClean = 0;
        private Process processInstance = null;

        public TrashProcessInstance(Process processInstance) {
            this.processInstance = processInstance;
        }

        public int getNumberOfClean() {
            return this.numberOfClean;
        }

        public void setNumberOfClean(int numberOfClean) {
            this.numberOfClean = numberOfClean;
        }

        public Process getProcessInstance() {
            return this.processInstance;
        }
    }
}

