/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easysawsdl10.api;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.with.WithAnyXmlObjects;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easysawsdl10.api.anonymoustype.AttrExtensions;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public final class SawsdlHelper {
    private static final QName MODEL_REF_QNAME = new QName("http://www.w3.org/ns/sawsdl", "modelReference");
    private static final QName LIFT_REF_QNAME = new QName("http://www.w3.org/ns/sawsdl", "liftingSchemaMapping");
    private static final QName LOWER_REF_QNAME = new QName("http://www.w3.org/ns/sawsdl", "loweringSchemaMapping");

    private SawsdlHelper() {
    }

    public static void addModelReference(XmlObject contextObject, URI ... uris) {
        if (contextObject instanceof WithOtherAttributes) {
            if (((WithOtherAttributes)contextObject).hasOtherAttribute(MODEL_REF_QNAME)) {
                String currentModelRef = ((WithOtherAttributes)contextObject).getOtherAttribute(MODEL_REF_QNAME);
                ((WithOtherAttributes)contextObject).addOtherAttribute(MODEL_REF_QNAME, currentModelRef + " " + SawsdlHelper.urisToString(uris));
            } else {
                ((WithOtherAttributes)contextObject).addOtherAttribute(MODEL_REF_QNAME, SawsdlHelper.urisToString(uris));
            }
        } else if (contextObject instanceof WithAnyXmlObjects) {
            if (((WithAnyXmlObjects)contextObject).hasAnyXmlObject(AttrExtensions.QNAME)) {
                AttrExtensions attr = (AttrExtensions)((WithAnyXmlObjects)contextObject).getFirstAnyXmlObject(AttrExtensions.class);
                String currentModelRef = attr.getOtherAttribute(MODEL_REF_QNAME);
                attr.addOtherAttribute(MODEL_REF_QNAME, currentModelRef + " " + SawsdlHelper.urisToString(uris));
            } else {
                AttrExtensions attr = (AttrExtensions)contextObject.getXmlContext().getXmlObjectFactory().create(AttrExtensions.class);
                attr.addOtherAttribute(MODEL_REF_QNAME, SawsdlHelper.urisToString(uris));
                ((WithAnyXmlObjects)contextObject).addAnyXmlObject((XmlObject)attr);
            }
        } else {
            throw new UncheckedException("Impossible to add semantic annontation on " + contextObject.getXmlObjectQName());
        }
    }

    public static URI[] getModelReference(XmlObject contextObject) {
        AttrExtensions attr;
        String modelRef = null;
        if (contextObject instanceof WithOtherAttributes) {
            modelRef = ((WithOtherAttributes)contextObject).getOtherAttribute(MODEL_REF_QNAME);
        } else if (contextObject instanceof WithAnyXmlObjects && (attr = (AttrExtensions)((WithAnyXmlObjects)contextObject).getFirstAnyXmlObject(AttrExtensions.class)) != null) {
            modelRef = attr.getOtherAttribute(MODEL_REF_QNAME);
        }
        if (modelRef != null) {
            return SawsdlHelper.stringToUris(modelRef);
        }
        return new URI[0];
    }

    public static void removeModelReference(XmlObject contextObject) {
        AttrExtensions attr;
        if (contextObject instanceof WithOtherAttributes) {
            ((WithOtherAttributes)contextObject).removeOtherAttribute(MODEL_REF_QNAME);
        } else if (contextObject instanceof WithAnyXmlObjects && (attr = (AttrExtensions)((WithAnyXmlObjects)contextObject).getFirstAnyXmlObject(AttrExtensions.class)) != null) {
            ((WithAnyXmlObjects)contextObject).removeAnyXmlObject((XmlObject)attr);
        }
    }

    public static void addLiftingSchemaMapping(Element contextObject, URI ... uris) {
        SawsdlHelper.addSchemaMapping((XmlObject)contextObject, LIFT_REF_QNAME, uris);
    }

    public static void addLiftingSchemaMapping(Type contextObject, URI ... uris) {
        SawsdlHelper.addSchemaMapping((XmlObject)contextObject, LIFT_REF_QNAME, uris);
    }

    public static URI[] getLiftingSchemaMapping(Element contextObject) {
        return SawsdlHelper.getSchemaMapping((XmlObject)contextObject, LIFT_REF_QNAME);
    }

    public static URI[] getLiftingSchemaMapping(Type contextObject) {
        return SawsdlHelper.getSchemaMapping((XmlObject)contextObject, LIFT_REF_QNAME);
    }

    public static void removeLiftingSchemaMapping(Element contextObject) {
        SawsdlHelper.removeSchemaMapping((XmlObject)contextObject, LIFT_REF_QNAME);
    }

    public static void removeLiftingSchemaMapping(Type contextObject) {
        SawsdlHelper.removeSchemaMapping((XmlObject)contextObject, LIFT_REF_QNAME);
    }

    public static void addLoweringSchemaMapping(Element contextObject, URI ... uris) {
        SawsdlHelper.addSchemaMapping((XmlObject)contextObject, LOWER_REF_QNAME, uris);
    }

    public static void addLoweringSchemaMapping(Type contextObject, URI ... uris) {
        SawsdlHelper.addSchemaMapping((XmlObject)contextObject, LOWER_REF_QNAME, uris);
    }

    public static URI[] getLoweringSchemaMapping(Element contextObject) {
        return SawsdlHelper.getSchemaMapping((XmlObject)contextObject, LOWER_REF_QNAME);
    }

    public static URI[] getLoweringSchemaMapping(Type contextObject) {
        return SawsdlHelper.getSchemaMapping((XmlObject)contextObject, LOWER_REF_QNAME);
    }

    public static void removeLoweringSchemaMapping(Element contextObject) {
        SawsdlHelper.removeSchemaMapping((XmlObject)contextObject, LOWER_REF_QNAME);
    }

    public static void removeLoweringSchemaMapping(Type contextObject) {
        SawsdlHelper.removeSchemaMapping((XmlObject)contextObject, LOWER_REF_QNAME);
    }

    private static void addSchemaMapping(XmlObject contextObject, QName mappingTypeQName, URI ... uris) {
        if (contextObject instanceof WithOtherAttributes) {
            if (((WithOtherAttributes)contextObject).hasOtherAttribute(mappingTypeQName)) {
                String currentModelRef = ((WithOtherAttributes)contextObject).getOtherAttribute(mappingTypeQName);
                ((WithOtherAttributes)contextObject).addOtherAttribute(mappingTypeQName, currentModelRef + " " + SawsdlHelper.urisToString(uris));
            } else {
                ((WithOtherAttributes)contextObject).addOtherAttribute(mappingTypeQName, SawsdlHelper.urisToString(uris));
            }
        }
    }

    private static URI[] getSchemaMapping(XmlObject contextObject, QName mappingTypeQName) {
        String schemaMapping = null;
        if (contextObject instanceof WithOtherAttributes) {
            schemaMapping = ((WithOtherAttributes)contextObject).getOtherAttribute(mappingTypeQName);
        }
        if (schemaMapping != null) {
            return SawsdlHelper.stringToUris(schemaMapping);
        }
        return new URI[0];
    }

    private static void removeSchemaMapping(XmlObject contextObject, QName mappingTypeQName) {
        if (contextObject instanceof WithOtherAttributes) {
            ((WithOtherAttributes)contextObject).removeOtherAttribute(mappingTypeQName);
        }
    }

    private static final URI[] stringToUris(String str) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String uri : str.split("\\s+")) {
            try {
                uris.add(new URI(uri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Problem in semantic annontation URIs: ", e);
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }

    private static final String urisToString(URI[] uris) {
        StringBuilder urisStr = new StringBuilder();
        for (URI uri : uris) {
            if (urisStr.length() != 0) {
                urisStr.append(" ");
            }
            urisStr.append(uri.toString());
        }
        return urisStr.toString();
    }
}

