/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easysawsdl10.impl;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easysawsdl10.api.anonymoustype.AttrExtensions;

import easybox.org.w3.ns.sawsdl.EJaxbAttrExtensions;

final class AttrExtensionsImpl extends AbstractJaxbXmlObjectImpl<EJaxbAttrExtensions> implements AttrExtensions, WithOtherAttributes {

	protected AttrExtensionsImpl(XmlContext xmlContext, EJaxbAttrExtensions jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbAttrExtensions> getCompliantModelClass() {
    	return EJaxbAttrExtensions.class;
	}
	
    @Override
    public final void addOtherAttribute(QName qname, String value) {
        getModelObject().getOtherAttributes().put(qname, value);
    }

    @Override
    public final void clearOtherAttributes() {
        getModelObject().getOtherAttributes().clear();
    }

    @Override
    public final String getOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().get(qname);
    }

    @Override
    public final Map<QName, String> getOtherAttributes() {
        return new HashMap<QName, String>(getModelObject().getOtherAttributes());
    }

    @Override
    public final boolean hasOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().containsKey(qname);
    }

    @Override
    public final void removeOtherAttribute(QName qname) {
        getModelObject().getOtherAttributes().remove(qname);
    }

}
