package com.ebmwebsourcing.easywsdl11.api;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

public final class WsdlHelper {

    private WsdlHelper() {}
    
    /**
     * Get parent {@link Definitions}.
     * 
     * @return Closest {@link Definitions} object in ancestors hierarychy, or {@code null}
     *  if no such ancestor.
     */
    public static Definitions findParentDefinitions(XmlObject contextObject) {
        XmlObject current = contextObject;
        while (current != null) {
            if (current instanceof Definitions) return (Definitions) current;
            current = current.getXmlObjectParent();
        }
        return null;
    }
    
}
