/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easywsdl11.api.element.Operation;
import com.ebmwebsourcing.easywsdl11.api.type.TPortType;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TPortTypeTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_OPERATIONS = "expectedOperations";

    public TPortTypeTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetOperations() {
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        Object[] expectedOperations = (Operation[])this.getTestData(EXPECTED_OPERATIONS);
        Assert.assertArrayEquals((Object[])expectedOperations, (Object[])tPortType.getOperations());
    }

    @Test
    public void testGetOperationByName() {
        Operation[] expectedOperations;
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        for (Operation expectedOperation : expectedOperations = (Operation[])this.getTestData(EXPECTED_OPERATIONS)) {
            if (expectedOperation.getName() == null) continue;
            Assert.assertEquals((Object)expectedOperation, (Object)tPortType.getOperationByName(expectedOperation.getName()));
        }
    }

    @Test
    public void testAddOperation() {
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        LinkedList<Operation> expectedOperations = new LinkedList<Operation>(Arrays.asList((Operation[])this.getTestData(EXPECTED_OPERATIONS)));
        Operation newOperation = (Operation)this.getXmlContext().getXmlObjectFactory().create(Operation.class);
        newOperation.setName("newOperationName");
        expectedOperations.add(newOperation);
        tPortType.addOperation(newOperation);
        Assert.assertEquals(expectedOperations, Arrays.asList(tPortType.getOperations()));
    }

    @Test
    public void testRemoveOperation() {
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        for (Operation e : tPortType.getOperations()) {
            tPortType.removeOperation(e);
            Assert.assertFalse((boolean)Arrays.asList(tPortType.getOperations()).contains(e));
        }
    }

    @Test
    public void testClearOperations() {
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        tPortType.clearOperations();
        Assert.assertEquals((long)0L, (long)tPortType.getOperations().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        Operation newOperation = (Operation)this.getXmlContext().getXmlObjectFactory().create(Operation.class);
        tPortType.addOperation(newOperation);
        Assert.assertEquals((Object)tPortType, (Object)newOperation.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        TPortType tPortType = (TPortType)this.newXmlObjectUnderTest();
        Operation newOperation = (Operation)this.getXmlContext().getXmlObjectFactory().create(Operation.class);
        tPortType.addOperation(newOperation);
        tPortType.removeOperation(newOperation);
        Assert.assertNull((Object)newOperation.getXmlObjectParent());
    }
}

